/*------------------------------------------------------------------------------*
 * File Name:ColDesignations.h													*
 * Creation: CPY 6/28/2003														*
 * Purpose: OriginC Class for managing column plot designations for the 		*
 * the Plot Setup dialog														*
 * Copyright (c) Originlab Corp. 2003, 2004, 2005, 2006, 						*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 8/17/03 9/9/03 ROW_NUMBER_ROW_IMPROVEMENT								*
 *	CPY 9/15/03 ROW_NUMBER_ROW_AUTO_SHOW_IF_NO_X_COL_IN_WKS						*
 *	CPY 9/15/03, SET_ALL_TO_TOP_NO_PLOT											*
 *	RVD 9/3/2003 QA70-5078 v7.0682 PLOT_RANGE_APPLY								*
 *	CPY 3/28/05 SHOW_BOOK_SHEET_NAME_WITH_MULTIPLE_SHEETS_SELECTED				*
 *	Jasmine 03/28/07 CHANGE_INCORRECT_CODE_TO_GET_WKS							*
 *	ML 4/12/2007 QA70-6961 PS_PLOT_RANGE_REMEMBERED_ON_REPLACE					*
 *	Jasmine 04/16/07 QA70-9632 INDEX_COLUMN_DATA_TYPE_SHOULD_BE_NUMERIC			*
 *	CPY 4/17/07 QA70-9625 EVEN_SPACED_X_PLOL_DEFAULT_TO_USE_COL_SETTINGS		*
 *	Jasmine 04/27/07 #9690 FIX_RUN_TIME_ERR										*
 *	CPY 7/17/07 QA70-9867 POLAR_XY_SWITCHED										*
 *	CPY 8/1/2007 QA70-9867 POLAR_XY_SWITCHED_FOR_XYZ_CONTOUR					*
 *	ML 12/3/2007 QA70-10661 P2 SWAPPED_POLAR_PLOT_SOME_PS_LC_WORK				*
 *	Hong 01/04/08 IMPROVE_CODE_BY_HINT_OF_CP									*
 *	Jasmine 07/09/08 QA80-11817-P3 PLOT_ALWAYS_USE_SAMPLING_INTERVAL_AS_X_IF_AVAILABLE	*
 *	Jasmine 07/09/08 QA80-11817-P3 FAIL_TO_PARSE_AUTO_IN_PLOT_STRING			*
 *	Jasmine 07/09/08 QA80-11817-P2 APPLY_DESIG_USE_ROW_NUM_ROW_AS_X_IF_NO_X_COL	*
 *	Jasmine 07/16/08 QA80-11817 MORE_COLUMN_INFO_AND_CHECK_MENU					*
 *  Kyle 07/18/08 CHANGE_INFO_COLUMN_SHOW_STYLE									*
 *	Kyle 07/18/08 ADD_FUNCTION_TO_DEAL_WITH_INFO_COLS_SHOW_EVENT				*
 *	Jasmine 07/16/08 QA80-11817 COLUMN_INFO_CLASS								*
 *	Kyle 07/21/08 ADD_TO_INIT_INFO_COLS_SHOW									*
 *	Kyle 07/22/08 SET_NO_NEED_TO_REBUILD_M_FLX_FORMAT_STRING					*
 *	Kyle 07/22/08 ADD_TWO_FUNCTION_TO_SAVE_AND_LOAD_SETTING_OF_INFO_COLS_SHOW	*
 *	Kyle 07/23/08 HIDE_SOME_INFO_COLS_WHILE_IT_IS_NOT_WKS						*
 *	Kyle 07/24/08 CHANGE_THE_NAME_OF_USER_DEFINED_PARAMETERS					*
 *	Kyle 07/24/08 SET_DEFAULT_SHOW_INFO_COLS									*
 *	Jasmine 07/24/08 SNOW_ASK_TO_SHOW_ACTUAL_USER_PARAM_NAME					*
 *	Kyle 07/25/08 READ_INFO_COLS_SETTING_ONLY_THE_FIRST_TIME					*
 *	Kyle 07/28/08 HIDE_THE_COL_OF_DISREGARDED_COL_DESIGNATION					*
 *	Kyle 07/29/08 HIDE_ALL_COLS_WHEN_NO_CONTENT									*
 *	Kyle 07/29/08 HIDE_SOME_INFO_COLS_USING_M_VN_HIDDEN_INFO_COLS				*
 *	Kyle 07/29/08 UNIFY_INFO_COLS_SHOW_AND_M_FLX								*
 *	Kyle 07/30/08 HIDE_INFO_COLS_THROUGH_THE_HIDDEN_LIST						*
 *	Kyle 07/30/08 UPDATE_LIST_WHEN_NO_CONTENT									*
 *	Kyle 07/31/08 SET_ROW_NUM_ROW_AS_DEFAULT_X_IF_NO_X_ASSIGNED					*
 *	Jasmine 07/31/08 QA80-11817-P6 ROW#_IS_NOT_CLEAR_INDICATE_SAMPLING_INTERVAL_AS_X
 *	CPY 7/31/08 QA70-11914-P10 SEPARATE_OUT_AUTO_X_INSTEAD_OF_AUTO_IN_SAMPLING_INTERVAL_X
 *	Jasmine 08/01/08 ALWAYS_SHOW_AUTOX_ROW_UNLESS_NOT_ALLOW						*
 *	Jasmine 08/08/08 QA80-11974 DETECT_DESIGNATION_AND_AUTO_SHOW				*
 *	Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION				*
 *	Jasmine 09/01/08 QA80-11938 ADD_CHANGE_DESIGNATION_MODE_BTN					*
 *	Jasmine 09/17/08 QA80-11938 AUTO_FIND_X_DESIGNATION							*
 *	Jasmine 09/17/08 QA80-12186 DESIGNATION_COLUMN_SHOW_STATUS_ONLY_DEPEND_ON_PLOT_TYPE
 *	Jasmine 09/24/08 QA80-11938-S1 ALLOW_PLOT_YERR_LABEL_COLUMNS_IN_DEFAULT_DESIGNATION_MODE
 *	Jasmine 09/24/08 GUI_CAN_SORT_AND_MAY_NOT_IN_SAME_ORDER_AS_m_vsColNames		*
 *	Jasmine 09/24/08 WKS_COLUMNS_MAY_HAVE_SAME_NAME 							*
 *	Jasmine 09/26/08 QA80-12285 AUTOX_INDEX_IS_MINUS_1										*
 *	Jasmine 09/27/08 QA80-12285-P3 GET_WRONG_COL_WITH_ROW_NUMBER_INDEX			*
 *	Jasmine 09/27/08 QA80-12285-P2 USE_AUTO_X_IF_COL_IS_EVEN_SAMPLING			*
 *	Jasmine 10/07/08 QA80-12338 AVOID_REDUNDANT_COL_STATUS_BIT_IN_REGISTRY		*
 *	Jasmine 10/09/08 QA80-11938 SHOW_DESIGNATION_IN_SHORT_NAME_COLUMN			*
 *	Jasmine 10/15/08 QA80-12369 INDEPENDENTLY_REMEMBER_EACH_MODE_SECLECTION		*
 *	Jasmine 10/17/08 QA80-12354 PCD_Z_PREFER_Y_IS_FOR_XYZ_PLOT_TYPE				*
 *	Jasmine 10/23/08 COL_INDEX_IN_GUI_MAY_NOT_CONSECUTIVE						*
 *	CPY 11/02/08 QA70-12467 MIXED_XY_AND_Y#_WITH_DESIGNATION_MODE_SHOULD_FOR_USING_XCOL
 *	Jasmine 11/04/08 QA80-12163 8.0965 IN_EDIT_MODE_ADD_BTN_NO_NEED_CHECK_HAS_TOO_MANY_Y
 *	Jasmine 11/21/08 v8.0978b QA80-11938 ADD_LABEL_OR_ERR_INTO_EXSITING_PLOT	*
 *	Jasmine 11/28/08 v8.0980d QA80-12437 SHOULD_REMEMBER_DESIGNATION_AND_AUTO_DETECT_LATER
 *	Jasmine 03/06/09 QA80-13219-P3 BRING_BACK_AUTO_X_MENU						*
 *	Jasmine 04/13/09 EXCEL_IS_A_KIND_OF_WORKSHEET								*
 *	Jasmine 04/14/09 AVOID_ACCESS_m_vsPageNames_WHEN_NOT_READY					*
 *	Jasmine 02/08/10 QA81-14754-P1&P2 COMMON_LNAME_NOT_MAKE_SENSE_FOR_ONE_SHEET	*
 *	Jasmine 02/08/10 QA81-14754-P1&P2 EMPTY_LNAME_CANNOT_PLOT					*
 *	Sophy 8/24/2010 ORG-681-P7 PROPER_CLEAR_COLLIST_SETTINGS_WHEN_INCOMPATIBLE_PAGE_SELECTED
 *	Sophy 9/10/2010 ORG-789 CREATE_3D_SCATTER_WITH_ERR_BAR_OR_VECTOR_IN_PLOT_SETUP_DIALOG
 *	Hong 10/13/10 ORG-35 FIX_ORIGIN_CRASH_WITH_NEW_GRID							*
 *------------------------------------------------------------------------------*/

#ifndef _COL_DESIGNATIONS_H
#define _COL_DESIGNATIONS_H

#include <GetNBox.h> // We need GetNBox support for Row# X start/increment values
#include <okocutils.h>

#include <..\OriginLab\OrgObjInfo.h>	///Jasmine 07/16/08 QA80-11817 COLUMN_INFO_CLASS


enum {
	INFO_COL_BEGIN 		= 0,//0 is for vector accessing
	
	INFO_COL_NAME 		= INFO_COL_BEGIN,
	INFO_COL_LONGNAME,
	INFO_COL_UNITS,		///Jasmine 07/16/08 QA80-11817 MORE_COLUMN_INFO_AND_CHECK_MENU
	INFO_COL_COMMENTS,
	INFO_COL_1ST_DATA, 
	INFO_COL_SAMPLING, 
	INFO_COL_PARAMETERS, 
	INFO_COL_USER_PARAM, 
	INFO_COL_INDEX,
	
	INFO_COL_END 		= INFO_COL_INDEX,
};

#define STR_HEADING_COL			_LC("Column", _CAT)
#define STR_HEADING_MAT			_LC("Matrix", _CAT)
#define STR_HEADING_DATASET		_LC("Dataset", _CAT)
//---- CPY 7/31/08 QA70-11914-P10 SEPARATE_OUT_AUTO_X_INSTEAD_OF_AUTO_IN_SAMPLING_INTERVAL_X
//#define STR_ROW_NUMBER			"<auto>"			//"Row#"	///Jasmine 07/31/08 QA80-11817-P6 ROW#_IS_NOT_CLEAR_INDICATE_SAMPLING_INTERVAL_AS_X
#define STR_ROW_NUMBER			STR_AUTOX
//----
#define STR_ROWNUM_ROW_LABEL	_LC("From/Step=",_CAT)

//---Jasmine 10/23/08 COL_INDEX_IN_GUI_MAY_NOT_CONSECUTIVE
static void _sort_colnames_by_colindex(vector<string>& vsColNames, vector<uint>& vnPositions)
{
	vector<uint> vnTemp, vnTemp2;
	vnPositions.Sort(SORT_ASCENDING, 1, vnTemp);	
	vnTemp.Sort(SORT_ASCENDING, 1, vnTemp2);	
	vsColNames.Reorder(vnTemp2);
}
//---end	

class ColListControl : public GridListControl
{
public:
	///Jasmine 09/17/08 QA80-12186 DESIGNATION_COLUMN_SHOW_STATUS_ONLY_DEPEND_ON_PLOT_TYPE
	//virtual 
	void GetHiddenCols(vector<byte>& vbCols)
	{
		vbCols.SetSize(0);
		for(int nCol = getInfoColBeginIndex(); nCol < m_flx.Cols; nCol++)
		{
			vbCols.Add(IsColHidden(nCol));
		}
	}
	//virtual 
	void SetHiddenCols(const vector<byte>& vbCols, bool bDefault = true)
	{
		for(int nCol = getInfoColBeginIndex(), ii = 0; nCol < m_flx.Cols; nCol++, ii++)
		{
			bool bHide = bDefault;
			if(ii < vbCols.GetSize())
				bHide = vbCols[ii];
			HideCol(nCol, bHide);
		}
	}
	///End DESIGNATION_COLUMN_SHOW_STATUS_ONLY_DEPEND_ON_PLOT_TYPE
	
	///Kyle 07/22/08 ADD_TWO_FUNCTION_TO_SAVE_AND_LOAD_SETTING_OF_INFO_COLS_SHOW
	void SaveInfoColsSetting()
	{
		///Kyle 07/29/08 UNIFY_INFO_COLS_SHOW_AND_M_FLX
		//if( !m_bIsInfoColsSettingRead )		//not read yet
			//return;
		int nSize = m_vnUnavailableInfoCols.GetSize();
		if( nSize > 0 )
		{
			int nInfoColBegin = getInfoColBeginIndex();
			for(int ii=0; ii<nSize; ii++)
			{
				int nIndex = m_vnUnavailableInfoCols[ii];
				SetIsColHidden(nInfoColBegin+nIndex, !m_vbInfoColsShow[nIndex]);
			}
		}
		///End UNIFY_INFO_COLS_SHOW_AND_M_FLX
		SaveHideCols();		
	}
	void LoadInfoColsSetting(LPCSTR lpcszDlgName)
	{
		//if(m_bIsInfoColsSettingRead)		///Kyle 07/25/08 READ_INFO_COLS_SETTING_ONLY_THE_FIRST_TIME
			//return;
		string strValName = "InfoColsShow";
		///Kyle 07/24/08 SET_DEFAULT_SHOW_INFO_COLS
		vector<byte> vbColsDefault;
		setDefaultHideCols(vbColsDefault);
		///End SET_DEFAULT_SHOW_INFO_COLS
				
		LoadHideCols(lpcszDlgName, strValName, &vbColsDefault);
		SetIsColHidden(m_nNameCol, false);	///Jasmine 10/07/08 QA80-12338 AVOID_REDUNDANT_COL_STATUS_BIT_IN_REGISTRY
		
		vector<byte> vbVal;
		GetHiddenCols(vbVal);
		
		///Jasmine 09/17/08 QA80-12186 DESIGNATION_COLUMN_SHOW_STATUS_ONLY_DEPEND_ON_PLOT_TYPE
		/*ASSERT(vbVal.GetSize()==m_flx.Cols);
		int nInfoCol = m_nRadioColEnd + 1;
		for(int ii=0;ii<m_vbInfoColsShow.GetSize();ii++)
		{
			m_vbInfoColsShow[ii] = !vbVal[nInfoCol++];
		}*/
		ASSERT(vbVal.GetSize()==m_nInfoCols);
		for(int ii=0;ii<m_vbInfoColsShow.GetSize();ii++)
			m_vbInfoColsShow[ii] = !vbVal[ii];
		///End DESIGNATION_COLUMN_SHOW_STATUS_ONLY_DEPEND_ON_PLOT_TYPE
		
		//m_bIsInfoColsSettingRead = true;
	}
	///End ADD_TWO_FUNCTION_TO_SAVE_AND_LOAD_SETTING_OF_INFO_COLS_SHOW
	ColListControl()
	{
		m_dwAuxPlotInfo = 0;
		m_dwAuxTypeInfo = 0;
		
		m_dwLayerBitsFromPlotTypeList = 0; //CPY 8/1/2007 QA70-9867 POLAR_XY_SWITCHED_FOR_XYZ_CONTOUR

		m_nNameCol = m_nLabelCol = m_n1stDataValCol = m_nIndexCol = 
		m_nCommentsCol = m_nUnitsCol = m_nParaetersCol = m_nUserParaCol = 
		m_nSamplingCol = -1;	///Jasmine 07/16/08 QA80-11817 MORE_COLUMN_INFO_AND_CHECK_MENU
		
		///Jasmine 07/16/08 QA80-11817 COLUMN_INFO_CLASS
		ASSERT(0 == INFO_COL_BEGIN);
		
		vector<uint> vnInfo;
		m_nInfoCols = getInfoTypes(vnInfo);
		m_ColInfo.SetInfoTypes(vnInfo);
		m_ColInfo.GetInfoNames(m_vsInfoCols);
		///Jasmine 07/24/08 SNOW_ASK_TO_SHOW_ACTUAL_USER_PARAM_NAME
		if(INFO_COL_USER_PARAM < m_nInfoCols)
			m_vsInfoCols[INFO_COL_USER_PARAM] = STR_UDL_PREFIX;
		///End SNOW_ASK_TO_SHOW_ACTUAL_USER_PARAM_NAME
		if(INFO_COL_INDEX < m_nInfoCols)
			m_vsInfoCols[INFO_COL_INDEX] = _L("Position");
		m_ColInfo.TurnOnOffset(true);
		///End COLUMN_INFO_CLASS
		
		///Kyle 07/18/08 CHANGE_INFO_COLUMN_SHOW_STYLE
		m_vbInfoColsShow.SetSize(m_nInfoCols);
		m_vbInfoColsShow = true;
		//m_bIsInfoColsSettingRead = false;		///Kyle 07/25/08 READ_INFO_COLS_SETTING_ONLY_THE_FIRST_TIME
		///End CHANGE_INFO_COLUMN_SHOW_STYLE
		
		m_nRadioColBegin = 0;
		m_nRadioColEnd = -1;
		//--------- CPY 4/17/07 QA70-9625 EVEN_SPACED_X_PLOL_DEFAULT_TO_USE_COL_SETTINGS
		//m_RowNumberXFrom = 1;
		//m_RowNumberXStep = 1;
		m_RowNumberXFrom = NANUM;
		m_RowNumberXStep = NANUM;
		//---------
		m_pOwner = NULL;
		m_bIsWksPages = false;
		m_bIsMatrixPage = false;
		m_bIsFunctionPlots = false;
		m_bIsVirtualMatrix = false;	///Sophy 8/3/2010 ORG-681-P2 PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG
		m_bEditMode = false;
		/// ML 4/12/2007 QA70-6961 PS_PLOT_RANGE_REMEMBERED_ON_REPLACE
		m_nRangeRows[0] = -1;		// -1 means auto
		m_nRangeRows[1] = -1;
		/// end PS_PLOT_RANGE_REMEMBERED_ON_REPLACE
	}
	
#ifdef CHANGE_DESIGNATION_MODE_BTN
	void Init(int nID, Dialog& dlg, uint nPlotID, const string& strRegForDlgInfo, int nMakePlotExVal, int nXErrID, int nPosNegErrID, int nAddRowNumForX, int nPageNames, int nShowAllCols, int nAutoApplyDesig, int nDesignationMode)
#else
	void Init(int nID, Dialog& dlg, uint nPlotID, const string& strRegForDlgInfo, int nMakePlotExVal, int nXErrID, int nPosNegErrID, int nAddRowNumForX, int nPageNames, int nShowAllCols, int nAutoApplyDesig)
#endif//CHANGE_DESIGNATION_MODE_BTN
	{
		m_pOwner = &dlg; // save this so we can cast to correct class later
		
		GridListControl::Init(nID, dlg);
		SetAlternateRowColors();
		m_flx.Cols = 1;// just to show at least something
		m_flx.ExtendLastCol =true;// false;
		m_flx.Editable = flexEDKbdMouse;
		m_flx.FocusRect = flexFocusLight;//flexFocusInset
		
		setSelectionMode();	///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
		
		///////////////
		m_nPlotType	= Project.GetPlotTypeInfo(nPlotID, m_dwAuxTypeInfo, m_dwAuxPlotInfo, m_strColPattern);
		countYs();
		m_nMakePlotExVal = nMakePlotExVal;
		///////////////
		
		m_chkXErrBars = dlg.GetItem(nXErrID);
		m_chkPosNegErrBars = dlg.GetItem(nPosNegErrID);
		m_chkAddRowNumX = dlg.GetItem(nAddRowNumForX);
		m_staticCntrlPageNames = dlg.GetItem(nPageNames);
		m_chkShowAllCols = dlg.GetItem(nShowAllCols);		
		m_chkApplyWks = dlg.GetItem(nAutoApplyDesig);				///Jasmine 08/06/09 QA81-13749 AUTO_APPLY_DESTINATIONS_IN_COL_LIST	
		
		///Jasmine 09/01/08 QA80-11938 ADD_CHANGE_DESIGNATION_MODE_BTN
#ifdef CHANGE_DESIGNATION_MODE_BTN		
		vector<string>  vstrTipsChangeMode;
		vstrTipsChangeMode.SetSize(2);
		vstrTipsChangeMode[0] = _L("Switch to Custom Mode");
		vstrTipsChangeMode[1] = _L("Switch to Default Mode");
		m_btnDesignation = dlg.GetItem(nDesignationMode);
		m_btnDesignation.Init(2, IDB_CHANGE_MODE_BTN, 16, vstrTipsChangeMode);
#endif//CHANGE_DESIGNATION_MODE_BTN
		///End ADD_CHANGE_DESIGNATION_MODE_BTN
		
		//setupGridCols();
		//LoadInfoColsSetting(STR_PLOT_SETUP_DLG);		//Kyle 07/22/08 ADD_TWO_FUNCTION_TO_SAVE_AND_LOAD_SETTING_OF_INFO_COLS_SHOW
	}
	bool OnReady(int nPageType)
	{
#ifdef CHANGE_DESIGNATION_MODE_BTN			
		m_bDesignation = m_btnDesignation.Check;	///Jasmine 09/01/08 QA80-11938 ADD_CHANGE_DESIGNATION_MODE_BTN
#endif//CHANGE_DESIGNATION_MODE_BTN

		///Kyle 07/30/08 UPDATE_LIST_WHEN_NO_CONTENT
		UpdateList(nPageType);
		LoadInfoColsSetting(STR_PLOT_SETUP_DLG);
		HideInfoCols();				///Kyle 07/30/08 HIDE_INFO_COLS_THROUGH_THE_HIDDEN_LIST
		///End UPDATE_LIST_WHEN_NO_CONTENT
		
#ifdef CHANGE_DESIGNATION_MODE_BTN				
		OnToggleDesignationMode();
#endif//CHANGE_DESIGNATION_MODE_BTN
		
		notifyDlgOnDesignationChanges(); // init the Add button
		return true;
	}
	
	int GetPlotType(DWORD *pdwAuxTypeInfo = NULL)
	{
		if (pdwAuxTypeInfo)
			*pdwAuxTypeInfo = m_dwAuxTypeInfo;
		return m_nPlotType;
	}
	
	bool IsAllowErrbars()
	{
		return IS_ALLOW_ERR_BARS(m_dwAuxTypeInfo);
	}
	bool IsAllowX() { return (m_dwAuxTypeInfo & PCD_NO_X)? false:true;}
	///Jasmine 03/06/09 QA80-13219-P3 BRING_BACK_AUTO_X_MENU this should replace IsAllowX
	bool IsRowNumberRowAllowed()
	{
		return (m_dwAuxTypeInfo & PCD_NO_X) || ( m_dwAuxTypeInfo & PCD_ONLY_ONE_Z)? false:true;
	}
	///End BRING_BACK_AUTO_X_MENU
	bool IsWorksheetPages() { return m_bIsWksPages;}
	
	Control GetItem(int nID)
	{
		Control cntrl;
		if(m_pOwner)
			cntrl = m_pOwner->GetItem(nID);
		return cntrl;
	}
	
	//virtual
	void ClearAll()
	{
		GridListControl::ClearAll();
		m_vsPageNames.SetSize(0);
		///Sophy 8/24/2010 ORG-681-P7 PROPER_CLEAR_COLLIST_SETTINGS_WHEN_INCOMPATIBLE_PAGE_SELECTED
		m_vsColNames.SetSize(0);
		m_vnColDesignations.SetSize(0);
		m_vsColLongNames.SetSize(0);
		m_vsLayerNames.SetSize(0);
		m_vsColWithDesig.SetSize(0);
		///end PROPER_CLEAR_COLLIST_SETTINGS_WHEN_INCOMPATIBLE_PAGE_SELECTED
		m_vnSelRows.SetSize(0);			///Jasmine 10/15/08 QA80-12369 INDEPENDENTLY_REMEMBER_EACH_MODE_SECLECTION
	}
	// return number of Col Designations that is greater then the given value
	int GetNumDesignationsAssigned(int nDesigBase = COLDESIG_NONE)
	{
		int nCount = 0;
		int nR1 = m_flx.FixedRows;
		int nR2 = m_flx.Rows;
		for(int nRow = nR1; nRow < nR2; nRow++)
		{
			if(getColDesignation(nRow) > nDesigBase)
				nCount++;
		}
		return nCount;
	}
	void ClearColDesignations(int nRow = -1, int nCol = -1, bool bAllDown = false, bool bKeepX = false, bool bRepaint = true);
	void ClearAllDesignations(bool bKeepX = true) {ClearColDesignations(-1, -1, bKeepX, true);}
	
	void SetColDesginations(int nRow, int nCol, bool bAllDown, bool bRepaint = true);// otherwise all up
	void ApplyWksColDesignations(bool bRepaint = false)
	{
		HOUR_GLASS
		
		int nR1 = m_flx.FixedRows;
		int nR2 = m_flx.Rows;
		string strColName;
		string str1stYDataset;
		
		///Jasmine 07/09/08 QA80-11817-P2 APPLY_DESIG_USE_ROW_NUM_ROW_AS_X_IF_NO_X_COL
		bool bHasXDesig = false;
		//bool bHaRowNumberRow = false;//not used anymore
		///End APPLY_DESIG_USE_ROW_NUM_ROW_AS_X_IF_NO_X_COL
		
		for(int nRow = nR1; nRow < nR2; nRow++)
		{
			//int nDesig = m_flx.RowData(nRow);
			strColName = GetTextMatrix(nRow, m_nNameCol);
			if(m_bIsWksPages)
			{
				///Jasmine 04/14/09 AVOID_ACCESS_m_vsPageNames_WHEN_NOT_READY
				string strWksName;
				if(m_vsPageNames.GetSize() <= 0 || m_vsLayerNames.GetSize() <= 0)
					ASSERT(0);
				else
					strWksName = make_book_sheet_name(m_vsPageNames[0], m_vsLayerNames[0]);
				///End AVOID_ACCESS_m_vsPageNames_WHEN_NOT_READY
		
				///Jasmine 03/28/07 CHANGE_INCORRECT_CODE_TO_GET_WKS
				//Worksheet wks(m_vsPageNames[0]);
				//string strWksName = make_book_sheet_name(m_vsPageNames[0], m_vsLayerNames[0]);
				Worksheet wks(strWksName);
				///End CHANGE_INCORRECT_CODE_TO_GET_WKS
				
				if(wks)
				{
					int nIndex = getColumnIndex(nRow);
					Column cc = wks.Columns(nIndex);
					if(!isRowNumber(nIndex) && cc)	///Jasmine 09/27/08 QA80-12285-P3 GET_WRONG_COL_WITH_ROW_NUMBER_INDEX
					{
						int nDesignation = colTypeToColDesignation(cc.GetType());
						if(COLDESIG_Y == nDesignation && str1stYDataset.IsEmpty())
							str1stYDataset = strColName;
	
						setDesignation(nRow, nDesignation);
						if(COLDESIG_X == nDesignation)
							bHasXDesig = true;
					}				
					//else if(getRowNumberRow() == nRow)	///Jasmine 07/09/08 QA80-11817-P2 APPLY_DESIG_USE_ROW_NUM_ROW_AS_X_IF_NO_X_COL
					//{
						//bHaRowNumberRow = m_chkAddRowNumX.Check;//not used anymore
					//}
				}
			}
			else if(m_bIsMatrixPage)
				setDesignation(nRow, COLDESIG_Z);
			else // loose datasets
			{
				DWORD dw = Project.GetDatasetInfo(strColName);
				if(PGDN_PLOTTABLE & dw)
				{
					if(str1stYDataset.IsEmpty())
						str1stYDataset = strColName;
					setDesignation(nRow, COLDESIG_Y);
				}
				else if(PGDN_IS_DATASET & dw)
					setDesignation(nRow, COLDESIG_X);
				else
					setDesignation(nRow, COLDESIG_NONE);
			}
		}
		///Kyle 07/31/08 SET_ROW_NUM_ROW_AS_DEFAULT_X_IF_NO_X_ASSIGNED
		//if(bHaRowNumberRow && !bHasXDesig)					///Jasmine 07/09/08 QA80-11817-P2 APPLY_DESIG_USE_ROW_NUM_ROW_AS_X_IF_NO_X_COL		
		if(!bHasXDesig)
		{
			///Jasmine 03/06/09 QA80-13219-P3 BRING_BACK_AUTO_X_MENU
			/////Jasmine 08/01/08 ALWAYS_SHOW_AUTOX_ROW_UNLESS_NOT_ALLOW
			///*
			if(!m_chkAddRowNumX.Check)
			{
				m_chkAddRowNumX.Check = true;
				OnChangeAddRowNumbers();
			}
			//*/
			/////End ALWAYS_SHOW_AUTOX_ROW_UNLESS_NOT_ALLOW
			///End BRING_BACK_AUTO_X_MENU
		///End SET_ROW_NUM_ROW_AS_DEFAULT_X_IF_NO_X_ASSIGNED
			setDesignation(getRowNumberRow(), COLDESIG_X);	
		}
			
		//----- CPY 9/9/03 ROW_NUMBER_ROW_IMPROVEMENT
		//--------- CPY 4/17/07 QA70-9625 EVEN_SPACED_X_PLOL_DEFAULT_TO_USE_COL_SETTINGS
		//m_RowNumberXFrom = 1;
		//m_RowNumberXStep = 1;
		m_RowNumberXFrom = NANUM;
		m_RowNumberXStep = NANUM;
		//---------
		if(IsRowNumberRowAllowed() && !str1stYDataset.IsEmpty())
		{
			///Jasmine 07/09/08 QA80-11817-P3 PLOT_ALWAYS_USE_SAMPLING_INTERVAL_AS_X_IF_AVAILABLE, not use From/Step any more
			/*double dbXFrom = 1, dbXStep = 1;
			string strDataset = m_bIsWksPages? m_vsPageNames[0] + "_" + str1stYDataset : str1stYDataset;
			if(GetDatasetXFromStep(strDataset, &dbXFrom, &dbXStep))
			{
				m_RowNumberXFrom = dbXFrom;
				m_RowNumberXStep = dbXStep;
				//--------- CPY 4/17/07 QA70-9625 EVEN_SPACED_X_PLOL_DEFAULT_TO_USE_COL_SETTINGS
				//updateRowNumberXFromAndStep();
				//---------
			}*/
			///End PLOT_ALWAYS_USE_SAMPLING_INTERVAL_AS_X_IF_AVAILABLE
			updateRowNumberXFromAndStep();//--------- CPY 4/17/07 QA70-9625 EVEN_SPACED_X_PLOL_DEFAULT_TO_USE_COL_SETTINGS
		}
		//----- end ROW_NUMBER_ROW_IMPROVEMENT

		if(bRepaint)
			updateDesignations();

		notifyDlgOnDesignationChanges();
	}
	
	///Jasmine 08/06/09 QA81-13749 AUTO_APPLY_DESTINATIONS_IN_COL_LIST	
	void OnAutoApplyColDesignations()
	{
		m_chkApplyWks.Check = !m_chkApplyWks.Check;
		if(m_chkApplyWks.Check)
			ApplyWksColDesignations(true);
	}
	///End AUTO_APPLY_DESTINATIONS_IN_COL_LIST
	
	///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
#ifdef CHANGE_DESIGNATION_MODE_BTN	
	void OnToggleDesignationMode()
	{		
		m_bDesignation = m_btnDesignation.Check;
		
		bool bHide = !m_bDesignation;
		///Jasmine 10/15/08 QA80-12369 INDEPENDENTLY_REMEMBER_EACH_MODE_SECLECTION
		///Jasmine 10/13/08 QA80-11938 SHOW_DESIGNATION_IN_SHORT_NAME_COLUMN
		vector<string> vsColNames;
		if(m_bDesignation)
		{
			vsColNames = m_vsColNames;
			
			//checkRadioOnSelection();	
			GetSelRows(m_vnSelRows);
			m_flx.SelectionMode = flexSelectionFree;
			m_flx.AllowSelection = false;			
			RemoveSelection();
			
			hideDesignationColumns(bHide);		
			updateShowColsRows();
		}
		else
		{
			vsColNames = m_vsColWithDesig;
			
			hideDesignationColumns(bHide);		
			updateShowColsRows();
		
			//selectOnRadioCheck();
			RemoveSelection();
			m_flx.SelectionMode = flexSelectionListBox;
			m_flx.AllowSelection = true;
			SelRows(m_vnSelRows);
		}
		///End INDEPENDENTLY_REMEMBER_EACH_MODE_SECLECTION
		vector<uint> vnPositions;
		vector<string> vsPositions;
		GetColValues( m_nIndexCol, vsPositions, GetRowOffset() );
		convert_string_vector_to_uint_vector(vsPositions, vnPositions);		
		_sort_colnames_by_colindex(vsColNames, vnPositions);//vsColNames.Reorder(vnPositions);	///Jasmine 10/23/08 COL_INDEX_IN_GUI_MAY_NOT_CONSECUTIVE
		SetColValues(m_nNameCol, vsColNames);		
		///End SHOW_DESIGNATION_IN_SHORT_NAME_COLUMN
	}
	bool IsDesignationMode()
	{
		return m_bDesignation;
	}
#endif//CHANGE_DESIGNATION_MODE_BTN
	///End DEFAULT_MODE_AUTO_GET_DESIGNATION
	
	// called from PlotList when a data plot is edited
	/// ML 4/12/2007 QA70-6961 PS_PLOT_RANGE_REMEMBERED_ON_REPLACE
	//bool OnStartEditPlot(int nPlotType, DWORD dwAuxTypeInfo, LPCSTR lpcszColPattern)
	bool OnStartEditPlot(int nPlotType, DWORD dwAuxTypeInfo, LPCSTR lpcszColPattern, int *pnRangeRows = NULL)
	/// end PS_PLOT_RANGE_REMEMBERED_ON_REPLACE
	{
		m_nPlotType = nPlotType;
		m_dwAuxTypeInfo = dwAuxTypeInfo;
		m_dwAuxPlotInfo = 0;
		m_strColPattern = lpcszColPattern;
		countYs();
		m_nMakePlotExVal = 0;
		m_bEditMode = true;
		/// ML 4/12/2007 QA70-6961 PS_PLOT_RANGE_REMEMBERED_ON_REPLACE
		if ( pnRangeRows )
		{
			m_nRangeRows[0] = pnRangeRows[0];
			m_nRangeRows[1] = pnRangeRows[1];
		}
		/// end PS_PLOT_RANGE_REMEMBERED_ON_REPLACE
		return true;
	}
	void OnEndEditPlot()
	{
		m_bEditMode = false;
	}
	bool IsInEditMode() { return m_bEditMode;}
	
	//---Jasmine 11/04/08 QA80-12163 8.0965 IN_EDIT_MODE_ADD_BTN_NO_NEED_CHECK_HAS_TOO_MANY_Y
	//bool IsReadyAddReplacePlot()
	bool IsReadyAddReplacePlot(bool bCheckEditMode = true)
	//---
	{	
		///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
#ifdef CHANGE_DESIGNATION_MODE_BTN	
		if(false == m_bDesignation)
		{
			return GetSelectedRow() >=  GetRowOffset();
		}
#endif//CHANGE_DESIGNATION_MODE_BTN
		///End DEFAULT_MODE_AUTO_GET_DESIGNATION
		
		int nMainColDesignations = 0;
		//if(IsRowNumberRowAllowed() && countDesignations(COLDESIG_X) != 1)
		if(IsRowNumberRowAllowed() && !(PCD_X_OPTIONAL & m_dwAuxTypeInfo) && countDesignations(COLDESIG_X) != 1)
			return false;
		bool bCountY = false;
		
		//---Jasmine 10/17/08 QA80-12354 PCD_Z_PREFER_Y_IS_FOR_XYZ_PLOT_TYPE
		//if(PCD_ONLY_ONE_Z & m_dwAuxTypeInfo)
		/// Fisher 09/07/2009 PLOT_SETUP_FIXING_FOR_TENERY_CONTOUR
		//if( (PCD_ONLY_ONE_Z & m_dwAuxTypeInfo) || (PCD_Z_PREFER_Y & m_dwAuxTypeInfo) )
		if ( PCD_Z_INDEP_FOR_TERNARY & m_dwAuxTypeInfo )
			nMainColDesignations = countDesignations(COLDESIG_ZDEP);
		else if( (PCD_ONLY_ONE_Z & m_dwAuxTypeInfo) || (PCD_Z_PREFER_Y & m_dwAuxTypeInfo) )
		/// End PLOT_SETUP_FIXING_FOR_TENERY_CONTOUR
			nMainColDesignations = countDesignations(COLDESIG_Z);
		else
		{
			bCountY = true;
			nMainColDesignations = countDesignations(COLDESIG_Y);
		}
		if(!bCountY && nMainColDesignations != 1) 
			return false;
		///Sophy 9/10/2010 ORG-789 CREATE_3D_SCATTER_WITH_ERR_BAR_OR_VECTOR_IN_PLOT_SETUP_DIALOG
#ifdef	__ZERROR_DESIG_IN_PLOT_SETUP_DLG__
		if ( !bCountY && IsAllowErrbars() && countDesignations(COLDESIG_ZERROR) != 1 )
			return false;
#endif	//__ZERROR_DESIG_IN_PLOT_SETUP_DLG__
		///end CREATE_3D_SCATTER_WITH_ERR_BAR_OR_VECTOR_IN_PLOT_SETUP_DIALOG
		
		if(!bCountY && (PCD_Z_PREFER_Y & m_dwAuxTypeInfo) && countDesignations(COLDESIG_Y) != 1) 
			return false;
		//---end
		if(bCountY && !hasEnoughYs(nMainColDesignations))
			return false;
		
		//---Jasmine 11/04/08 QA80-12163 8.0965 IN_EDIT_MODE_ADD_BTN_NO_NEED_CHECK_HAS_TOO_MANY_Y
		//if(bCountY && IsInEditMode() && hasTooManyYs(nMainColDesignations))
		if(bCountY && bCheckEditMode)
		{
			if(IsInEditMode() && hasTooManyYs(nMainColDesignations))
			{
				return false;
			}
		}
		//---
		
		if(m_nModifiers > 0 && countModifiers() != m_nModifiers)
			return false;
		
		return true;
	}
	// called mainly from PlotTypeListControl
	void OnChangePlotType(DWORD dwLayerBits, int nNewPlotID, int nPageType = 0, int nPlotExVal = 0)
	{		
		//RemoveSelection();	///Jasmine 10/15/08 QA80-12369 INDEPENDENTLY_REMEMBER_EACH_MODE_SECLECTION
		if( 0 == nNewPlotID )
		{
			ClearAll();
			return;
		}
		updatePlotType(nNewPlotID, nPageType, dwLayerBits);
		m_nMakePlotExVal = nPlotExVal;			
		updateListAfterChange(false, false, true);
	}
	///Jasmine 10/15/08 QA80-12369 INDEPENDENTLY_REMEMBER_EACH_MODE_SECLECTION
	bool ApplyColDesignations(const vector<string>&	vsColNames, const vector<uint>&	vnColDesignations, bool bRepaint = true)
	{
		bool bRet;
#ifdef CHANGE_DESIGNATION_MODE_BTN			
		if(false == m_bDesignation)
			bRet = selRowToApplyColDesignations(vsColNames, vnColDesignations);
		else
#endif//CHANGE_DESIGNATION_MODE_BTN
			bRet = checkRadioToApplyColDesignations(vsColNames, vnColDesignations, bRepaint);
			
		return bRet;
	}
	///End INDEPENDENTLY_REMEMBER_EACH_MODE_SECLECTION
	
	int	GetNumLayers()
	{
		int		nNum = m_dwAuxPlotInfo & LTPI_LAYERS_NUMBER_MASK;
		if (nNum < 1)
			nNum = 1;
		
		return nNum;
	}	
	void UpdateList(int nPageType)// from default if no wks name given
	{
		///Kyle 07/30/08 UPDATE_LIST_WHEN_NO_CONTENT
		//vector<string> vsWksNames;
		/////Jasmine 04/27/07 #9690 FIX_RUN_TIME_ERR
		////WorksheetPage wksPage = Project.Pages();
		//Worksheet wks = Project.ActiveLayer();
		//if(wks)//wksPage)
		//{
			///// Hong 01/04/08 IMPROVE_CODE_BY_HINT_OF_CP
			////string strWksName;
			////wks.GetRangeString(strWksName);
			////strWksName.TrimRight('!');
			////vsWksNames.Add(strWksName);//wksPage.GetName());
			//vsWksNames.Add(wks.m_strBookSheet);
			///// end IMPROVE_CODE_BY_HINT_OF_CP
		/////End FIX_RUN_TIME_ERR
			//UpdateList(vsWksNames);
		//}
		//else
			//ClearAll();
		ClearAll();
		m_vsColNames.SetSize(0);
		m_vsColLongNames.SetSize(0);
		vector<string> vsWksPageNames;
		updateWksPageNames(vsWksPageNames, nPageType);
		updateShowWksNames();
		SetHiddenInfoCols();
		updateColHeading();
		setupGridCols();
		updateColWidths();
		///End UPDATE_LIST_WHEN_NO_CONTENT
	}
	void UpdateList(vector<string>& vsWksPageNames, bool bApplyWks = false, int nPageType = 0, int nCommonColsMode = -1)
	{
		//---- CPY 1/2/2007 QA70-9168-P2 POPUP_MENU_FOR_COMMON_COL_CHOICES
		if(nCommonColsMode >= 0)
			m_nCommonColsModeSave = nCommonColsMode;
		//----
		///Jasmine 02/08/10 QA81-14754-P1&P2 COMMON_LNAME_NOT_MAKE_SENSE_FOR_ONE_SHEET
		if(COMMCMODE_LONG_NAMES == m_nCommonColsModeSave && vsWksPageNames.GetSize() < 2)
			m_nCommonColsModeSave = COMMCMODE_SHORT_NAMES;
		///End COMMON_LNAME_NOT_MAKE_SENSE_FOR_ONE_SHEET
		
		ClearAll();
		///Jasmine 03/06/09 QA80-13219-P3 BRING_BACK_AUTO_X_MENU
		/////Jasmine 08/01/08 ALWAYS_SHOW_AUTOX_ROW_UNLESS_NOT_ALLOW
		///*
		//--- CPY 9/15/03 ROW_NUMBER_ROW_AUTO_SHOW_IF_NO_X_COL_IN_WKS
		///Jasmine 04/13/09 EXCEL_IS_A_KIND_OF_WORKSHEET
		//if(EXIST_WKS == nPageType && !m_chkAddRowNumX.Check)
		if((EXIST_WKS == nPageType || EXIST_EXTERN_WKS == nPageType) && !m_chkAddRowNumX.Check)
		///End EXCEL_IS_A_KIND_OF_WORKSHEET
		{
			Worksheet wks(vsWksPageNames[0]);
			if(wks)
			{
				string strColDesigs = wks.GetColDesignations();
				if(strColDesigs.Find('X') < 0) // no X col in wks
				{
					//out_str("Force Row#");
					m_chkAddRowNumX.Check = true;
				}
			}
		}
		//--- end
		//*/
		/////End ALWAYS_SHOW_AUTOX_ROW_UNLESS_NOT_ALLOW
		///End BRING_BACK_AUTO_X_MENU
		
		if(nPageType < EXIST_DATA)
			nPageType = guessPageType(vsWksPageNames[0]);
			
		updateWksPageNames(vsWksPageNames, nPageType);
		updateShowWksNames();
		SetHiddenInfoCols();
		updateColHeading();								//Kyle 07/24/08 CHANGE_THE_NAME_OF_USER_DEFINED_PARAMETERS
		setupGridCols();
		//LoadInfoColsSetting(STR_PLOT_SETUP_DLG);		//Kyle 07/22/08 ADD_TWO_FUNCTION_TO_SAVE_AND_LOAD_SETTING_OF_INFO_COLS_SHOW
		vector<string> vsColNames, vsColLongNames;
		///Jasmine 10/13/08 QA80-11938 SHOW_DESIGNATION_IN_SHORT_NAME_COLUMN
		vector<string> vsColWithDesig;

		
		m_vsColWithDesig.SetSize(0);
		m_vsColNames.SetSize(0);
		m_vsColLongNames.SetSize(0);
		//---- CPY 1/2/2007 QA70-9168-P2 POPUP_MENU_FOR_COMMON_COL_CHOICES
		//if(vsWksPageNames.GetSize() && Project.GetCommonColumns(vsWksPageNames, vsColNames, vsColLongNames, isKeepColOrder()))
		int nMode = m_nCommonColsModeSave;
		if(isKeepColOrder())
			nMode |= COMMCMODE_KEEP_ORDER;
		
		///Sophy 8/3/2010 ORG-681-P2 PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG
		if ( IsVirtualMatrix() )
		{
			for ( int iData = 0; iData < vsWksPageNames.GetSize(); iData++ )
			{
				m_vsColWithDesig.Add(vsWksPageNames[iData]);
				m_vsColNames.Add(vsWksPageNames[iData]);
				m_vsColLongNames.Add(okutil_get_virtual_matrix_long_name(vsWksPageNames[iData]));
			}
		}
		else
		{
		///end PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG
			//if(vsWksPageNames.GetSize() && Project.GetCommonColumns(vsWksPageNames, vsColNames, vsColLongNames, nMode))	
			if(vsWksPageNames.GetSize() && Project.GetCommonColumns(vsWksPageNames, vsColNames, vsColLongNames, nMode, vsColWithDesig)
				&& checkEmptyItem(nMode, vsColNames, vsColLongNames, vsColWithDesig) )///Jasmine 02/08/10 QA81-14754-P1&P2 EMPTY_LNAME_CANNOT_PLOT
			//----
			{
				///Sophy 8/3/2010 ORG-681-P2 PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG
				//if(IsRowNumberRowAllowed())//getRowNumberRow(false) > 0)
				if ( IsRowNumberRowAllowed() && !IsVirtualMatrix() )
				///end PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG
				{
					m_vsColWithDesig.Add(STR_ROW_NUMBER);
					m_vsColNames.Add(STR_ROW_NUMBER);
					m_vsColLongNames.Add(getXFromStepStr());
					m_RowNumberXFrom = m_RowNumberXStep = NANUM;	///Jasmine 07/09/08 QA80-11817-P3 FAIL_TO_PARSE_AUTO_IN_PLOT_STRING, reset when wks change
				}
				m_vsColWithDesig.Append(vsColWithDesig);
				m_vsColNames.Append(vsColNames);
				m_vsColLongNames.Append(vsColLongNames);
			}
		}
		///End SHOW_DESIGNATION_IN_SHORT_NAME_COLUMN
		updateListAfterChange(bApplyWks, true);
	}
	///Jasmine 02/08/10 QA81-14754-P1&P2 EMPTY_LNAME_CANNOT_PLOT
	bool checkEmptyItem(DWORD dwMode, vector<string> &columnNames, vector<string> &columnLabels, vector<string> &columnHeadings = NULL)
	{ 
		if(dwMode & COMMCMODE_LONG_NAMES)
		{
			for(int ii = columnLabels.GetSize() - 1; ii >= 0; ii--)
			{
				string strLongName = columnLabels[ii];
				if( !strLongName.IsEmpty() )
					continue;
				
				columnLabels.RemoveAt(ii);
				
				if(columnNames.GetSize() > ii)
					columnNames.RemoveAt(ii);
				
				if(columnHeadings && columnHeadings.GetSize() > ii)
					columnHeadings.RemoveAt(ii);
			}
			if(columnLabels.GetSize() <= 0)
				return false;
		}
		
		return true;
	}
	///End EMPTY_LNAME_CANNOT_PLOT
	///Kyle 07/18/08 ADD_FUNCTION_TO_DEAL_WITH_INFO_COLS_SHOW_EVENT
	void OnInfoColsShow(int nCmd)
	{
		int nInfoCol;
		//RemoveSelection();	///Jasmine 10/15/08 QA80-12369 INDEPENDENTLY_REMEMBER_EACH_MODE_SECLECTION

		if(nCmd < m_nInfoCols)
		{
			nInfoCol = getInfoColBeginIndex() + nCmd;//nCmd: 0 offset
			SetIsColHidden(nInfoCol, m_vbInfoColsShow[nCmd]);
			m_vbInfoColsShow[nCmd] = m_vbInfoColsShow[nCmd] ? false:true;
		}
		else	//show all
		{
			nInfoCol = getInfoColBeginIndex();
			
			vector<uint> vecIndex;
			for(int ii=0; ii<m_nInfoCols; ii++)
			{
				if(m_vnUnavailableInfoCols.Find(vecIndex, ii)<=0)//not in N/A list
				{
					SetIsColHidden(nInfoCol, false);
					m_vbInfoColsShow[ii] = true;
				}
				nInfoCol++;
			}
		}
		
		updateDesignations(true);
	}
	///End ADD_FUNCTION_TO_DEAL_WITH_INFO_COLS_SHOW_EVENT
	void OnChangeAddRowNumbers()
	{
		//RemoveSelection();	///Jasmine 10/15/08 QA80-12369 INDEPENDENTLY_REMEMBER_EACH_MODE_SECLECTION
		updateRowNumbersRow();
		updateColWidths();
	}
	void updateColWidths()
	{
		ResizeCols(4);
	}
	void OnChangeErrBarOptions()
	{
		//RemoveSelection();	///Jasmine 10/15/08 QA80-12369 INDEPENDENTLY_REMEMBER_EACH_MODE_SECLECTION

		///Kyle 07/22/08 SET_NO_NEED_TO_REBUILD_M_FLX_FORMAT_STRING
		setupGridCols();
		updateColNameLabelsAndOtherInfo(false);
		//m_flx.ColHidden(m_nXError) = !(IsAllowErrbars() && m_chkXErrBars.Check);
		//if(IsAllowErrbars() && m_chkPosNegErrBars.Check)
		//{
			//m_flx.ColHidden(m_nYMinusError) = false;
			//m_vnColDesignations[ m_nYPlusError - 1 ] = COLDESIG_YPLUSERROR;
			//SetColHeading( m_nYPlusError, getColDesignationName( COLDESIG_YPLUSERROR ));
		//}
		//else
		//{
			//m_flx.ColHidden(m_nYMinusError) = true;
			//m_vnColDesignations[ m_nYError -1 ] = COLDESIG_YERROR;
			//SetColHeading( m_nYError, getColDesignationName( COLDESIG_YERROR ) );
		//}
		///End SET_NO_NEED_TO_REBUILD_M_FLX_FORMAT_STRING
		//ResizeCols(4);
		updateDesignations(true);
	}

	/// RVD 9/3/2003 QA70-5078 v7.0682 PLOT_RANGE_APPLY
	//bool GetDataPlots(TreeNode& trPlotList, bool bTestValid = false)
	bool GetDataPlots(TreeNode& trPlotList, bool bTestValid = false, DWORD dwPlotView = DPEDTVIEW_HIDE_LIMITS)
	/// end PLOT_RANGE_APPLY
	{
		vector<uint> vnColDesignations;
		//----- CPY 8/20/03 ADD_PLOT_WRONG_X_AFTER_SORT
		//---Jasmine 09/26/08 QA80-12285 AUTOX_INDEX_IS_MINUS_1
		//vector<uint> vnPositions;	
		vector<int> vnPositions;
		//---end
		getColDesignations(vnColDesignations, vnPositions);
		vector<uint> vnReorderIndexes;
		vnPositions.Sort(SORT_ASCENDING, TRUE, vnReorderIndexes);
		vnColDesignations.Reorder(vnReorderIndexes);
		//-----		
		
		string strSaveRowNumberDisplay;
		int nRow = -1;
		if((nRow = getRowNumberRow()) > 0)
		{
			nRow = 0;//-= m_flx.FixedRows;
			strSaveRowNumberDisplay = m_vsColNames[nRow];// Row# is always at index 0
			m_vsColNames[nRow] = m_vsColLongNames[nRow];
			m_vsColLongNames[nRow] = "";
		}
		
		if (PCD_LTPLOTINFO_HAS_NEXVAL & m_dwAuxTypeInfo)
		{
			DWORD		dwExValue = m_dwAuxPlotInfo & LTPI_NEXVAL_MASK;
			m_nMakePlotExVal = dwExValue >> NEXVAL_MASK_BITSHIFT_IN_LTPI;
		}
		
		vector<string> vsPagesSave;
		if(bTestValid) // if testing, only need 1st page
		{
			vsPagesSave = m_vsPageNames;
			m_vsPageNames.SetSize(1);
		}
		
//----- CPY 1/2/2007 QA70-9168-P2 POPUP_MENU_FOR_COMMON_COL_CHOICES
//		BOOL bNoLimits = (dwPlotView & DPEDTVIEW_HIDE_LIMITS) ? TRUE : FALSE;
//		bool bRet = Project.MakeDataplotsTree(trPlotList, m_nPlotType, m_dwAuxTypeInfo, m_dwAuxPlotInfo, m_strColPattern, m_nMakePlotExVal,
//			vnColDesignations, m_vsPageNames, m_vsLayerNames, m_vsColNames, bNoLimits);
		DWORD dwCntrl = dwPlotView;
		//----- CPY 11/02/08 QA70-12467 MIXED_XY_AND_Y#_WITH_DESIGNATION_MODE_SHOULD_FOR_USING_XCOL
		if(IsDesignationMode())
			dwCntrl |= DPEDTVIEW_FORCE_USE_SHARE_X;
		//-----
		bool bRet = false;
		vector<string> vsNames;
		if(COMMCMODE_LONG_NAMES == m_nCommonColsModeSave)
		{
			dwCntrl |= DPEDTVIEW_COL_LONGNAMES;
			vsNames = m_vsColLongNames;
		}
		else if(COMMCMODE_COL_INDEX == m_nCommonColsModeSave)
		{
			///Jasmine 09/24/08 WKS_COLUMNS_MAY_HAVE_SAME_NAME 
			/*Page pg(m_vsPageNames[0]);
			Worksheet wks = pg.Layers(m_vsLayerNames[0]);
			for(int ii = 0; ii <  m_vsColNames.GetSize(); ii++)
			{
				Column cc = wks.Columns(m_vsColNames[ii]);
				string str; str.Format("%d", cc.GetIndex());
				vsNames.Add(str);
			}*/
			convert_int_vector_to_string_vector(vnPositions, vsNames);
			///End WKS_COLUMNS_MAY_HAVE_SAME_NAME
			dwCntrl |= DPEDTVIEW_COL_BY_INDEX;
		}
		else
			vsNames = m_vsColNames;

		/// ML 4/12/2007 QA70-6961 PS_PLOT_RANGE_REMEMBERED_ON_REPLACE
		//bRet = Project.MakeDataplotsTree(trPlotList, m_nPlotType, m_dwAuxTypeInfo, m_dwAuxPlotInfo, m_strColPattern, m_nMakePlotExVal,
		//	vnColDesignations, m_vsPageNames, m_vsLayerNames, vsNames, dwCntrl);
		int			*pnRangeRows = NULL;
		if (DPEDTVIEW_REPLACE & dwPlotView)
			pnRangeRows = m_nRangeRows;
		bRet = Project.MakeDataplotsTree(trPlotList, m_nPlotType, m_dwAuxTypeInfo, m_dwAuxPlotInfo, m_strColPattern, m_nMakePlotExVal,
			vnColDesignations, m_vsPageNames, m_vsLayerNames, vsNames, dwCntrl, pnRangeRows);
		/// end PS_PLOT_RANGE_REMEMBERED_ON_REPLACE
		ASSERT(bRet);
//-----

		if(bTestValid) // if testing, only need 1st page, now restore
			m_vsPageNames = vsPagesSave;

		if(nRow >= 0)
		{
			m_vsColLongNames[nRow] = m_vsColNames[nRow];
			m_vsColNames[nRow] = strSaveRowNumberDisplay;
		}
		return bRet;
	}
	
	///Sophy 8/3/2010 ORG-681-P2 PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG
	BOOL	IsVirtualMatrix()
	{
		return m_bIsVirtualMatrix;
	}
	///end PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG

private:
	int getInfoColBeginIndex(){return  m_nRadioColEnd + 1;}
	
	///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
	void setSelectionMode()
	{
		if(0) // multiple selection, this is powerful, but could be confusing in terms of GUI
		{
			m_flx.SelectionMode = flexSelectionByRow;//flexSelectionFree;flexSelectionListBox;//
			m_flx.AllowSelection = true;
		}
		/*else if(m_bDesignation)
		{
			m_flx.SelectionMode = flexSelectionFree;
			m_flx.AllowSelection = false;
		}*/
		else
		{
			m_flx.SelectionMode = flexSelectionListBox;
			m_flx.AllowSelection = true;
		}
		
	}
	
#ifdef CHANGE_DESIGNATION_MODE_BTN	
	void hideDesignationColumns(bool bHide)
	{
		SetIsColHidden(m_nRadioColBegin, true);
		for(int nCol = m_nRadioColBegin + 1; nCol <= m_nRadioColEnd; nCol++)
			SetIsColHidden(nCol, bHide);
	}
#endif//CHANGE_DESIGNATION_MODE_BTN

///Jasmine 10/15/08 QA80-12369 INDEPENDENTLY_REMEMBER_EACH_MODE_SECLECTION
/*#ifdef CHANGE_DESIGNATION_MODE_BTN
	void checkRadioOnSelection()
	{
		for(int nRow = m_flx.FixedRows; nRow < m_flx.Rows; nRow++)
		{
			int nDesig = getColDesignationFromColType(nRow);
			if(nDesig > COLDESIG_NONE)
			//setDesignationRadioChoice(nRow, nDesig);
			setDesignation(nRow, nDesig);
		}
		
		updateDesignations(true);
	}
	void selectOnRadioCheck()
	{
		RemoveSelection();
		
		vector<uint> vnRows;
		for(int nRow = m_flx.FixedRows; nRow < m_flx.Rows; nRow++)
		{
			//if( !m_flx.RowHidden(nRow) && COLDESIG_NONE < getColDesignation(nRow) )
			if( !m_flx.RowHidden(nRow) && isSelectable( getColDesignation(nRow) ) )
			{
				vnRows.Add(nRow);
			}
		}
		
		if( 0 < vnRows.GetSize() )
			SelRows(vnRows);
	}
	bool isSelectable(int nDesignation)
	{
		if( is2DPlot() )
			return COLDESIG_Z == nDesignation;
		
		vector<int> vnSel = {COLDESIG_Y, COLDESIG_LABEL, COLDESIG_YERROR};
		vector<uint> vecIndex;
		return 0 < vnSel.Find(vecIndex, nDesignation);
	}
#endif//CHANGE_DESIGNATION_MODE_BTN*/		
	bool checkRadioToApplyColDesignations(const vector<string>&	vsColNames, const vector<uint>&	vnColDesignations, bool bRepaint = true)
	{
		HOUR_GLASS
		
		showDesignationCol(vnColDesignations);	///Jasmine 08/08/08 QA80-11974 DETECT_DESIGNATION_AND_AUTO_SHOW
		
		int nRow;
		for(int ii = 0; ii < vsColNames.GetSize(); ii++)
		{
			nRow = FindRow(vsColNames[ii], m_nNameCol);
			if(nRow >= 0 && ii < vnColDesignations.GetSize())
				setDesignation(nRow, vnColDesignations[ii]);
			else if(nRow < 0 && (nRow = getRowNumberRow()) > 0) // not found, check to see if Row# CPY 8/21/03 QA70-5034
			{
				//---- CPY 4/17/07 QA70-9625 EVEN_SPACED_X_PLOL_DEFAULT_TO_USE_COL_SETTINGS
				//if(COLDESIG_X == vnColDesignations[ii] && vsColNames[ii].Find('/') > 0) // From/Step
				if(COLDESIG_X == vnColDesignations[ii] )//&& okutil_get_even_spaced_x_from_str(vsColNames[ii]))	///Jasmine 07/09/08 QA80-11817-P3 FAIL_TO_PARSE_AUTO_IN_PLOT_STRING
				//----
				{
					setDesignation(nRow, COLDESIG_X);
					setXFromStepStr(vsColNames[ii]);
				}
			}
		}
		if(bRepaint)
			updateDesignations();
					
		notifyDlgOnDesignationChanges();
		return true;
	}
#ifdef CHANGE_DESIGNATION_MODE_BTN
	bool selRowToApplyColDesignations(const vector<string>&	vsColNames, const vector<uint>&	vnColDesignations)
	{
		HOUR_GLASS
		
		vector<uint> vnRows;
		bool bSelPlotCol = !GetSelRows(vnRows);
		
		showDesignationCol(vnColDesignations);
		
		///Jasmine 11/21/08 v8.0978b QA80-11938 ADD_LABEL_OR_ERR_INTO_EXSITING_PLOT
		m_nMainCol = -1;
		int nRow;
		for(int ii = 0; ii < vsColNames.GetSize(); ii++)
		{
			nRow = FindRow(vsColNames[ii], m_nNameCol);
			if(nRow < 0 && (nRow = getRowNumberRow()) > 0 && ii < vnColDesignations.GetSize() && COLDESIG_X == vnColDesignations[ii] )
			{
				setXFromStepStr(vsColNames[ii]);
			}
			
			if(bSelPlotCol)
				vnRows.Add(nRow);
			
			if(mainDesigInPlot() == vnColDesignations[ii] && m_nMainCol == -1)
				m_nMainCol = getColumnIndex(nRow);
		}
		///End ADD_LABEL_OR_ERR_INTO_EXSITING_PLOT
		if(bSelPlotCol)
			SelRows(vnRows);
			
		notifyDlgOnDesignationChanges();
		return true;
	}
#endif//CHANGE_DESIGNATION_MODE_BTN
///End INDEPENDENTLY_REMEMBER_EACH_MODE_SECLECTION
	
#ifdef CHANGE_DESIGNATION_MODE_BTN	
	bool isPlotable(const Column& cc)
	{
		int nType = cc.GetType();
		
		if( is2DPlot() )
			return OKDATAOBJ_DESIGNATION_Z == nType;
		///Jasmine 09/24/08 QA80-11938-S1 ALLOW_PLOT_YERR_LABEL_COLUMNS_IN_DEFAULT_DESIGNATION_MODE
		//return OKDATAOBJ_DESIGNATION_Y == nType;
		vector<int> vnAllowPlot = {OKDATAOBJ_DESIGNATION_Y, OKDATAOBJ_DESIGNATION_ERROR, OKDATAOBJ_DESIGNATION_L/*, OKDATAOBJ_DESIGNATION_X_ERROR*/};
		vector<uint> vecIndex;
		return 0 < vnAllowPlot.Find(vecIndex, nType);
		///End ALLOW_PLOT_YERR_LABEL_COLUMNS_IN_DEFAULT_DESIGNATION_MODE
	}
	bool is2DPlot()
	{
		vector<uint> vecIndex;
		return 0 < m_vnColDesignations.Find(vecIndex,COLDESIG_Z);
	}
#endif//CHANGE_DESIGNATION_MODE_BTN
	///End DEFAULT_MODE_AUTO_GET_DESIGNATION

///Jasmine 09/17/08 QA80-11938 AUTO_FIND_X_DESIGNATION
#ifdef CHANGE_DESIGNATION_MODE_BTN
	///Jasmine 11/21/08 v8.0978b QA80-11938 ADD_LABEL_OR_ERR_INTO_EXSITING_PLOT	
	void guessMainDesigCol(vector<uint>& vnColDesignations, vector<int>& vnPositions)
	{
		int nMainDesig = mainDesigInPlot();
		
		vector<uint> vecIndex;
		if(vnColDesignations.Find(vecIndex, nMainDesig) > 0)
			return;
		
		/*only when sel label/err columns we need guess their main column
		now only xy plot allow label/err	*/
		ASSERT(COLDESIG_Y == nMainDesig);
		
		vector<uint> vnReorderIndexes;
		vnPositions.Sort(SORT_ASCENDING, TRUE, vnReorderIndexes);
		vnColDesignations.Reorder(vnReorderIndexes);
		
		vector<uint> vnDepDesigIndex;
		vnColDesignations.Find(vnDepDesigIndex, COLDESIG_LABEL);
		vnColDesignations.Find(vecIndex, COLDESIG_YERROR);
		vnDepDesigIndex.Append(vecIndex);
		int nSize = vnDepDesigIndex.GetSize();
		if(nSize <= 0)
			return;
		
		//use main col in selected plot
		if(m_bEditMode && m_nMainCol > -1)
		{
			if(vnPositions.Find(vecIndex, m_nMainCol) > 0)
				vnColDesignations[ vecIndex[0] ] = nMainDesig;	
			
			return;
		}
		
		//find left-nearest Y
		///Jasmine 04/14/09 AVOID_ACCESS_m_vsPageNames_WHEN_NOT_READY
		if(m_vsPageNames.GetSize() <= 0 || m_vsLayerNames.GetSize() <= 0)
		{
			ASSERT(0);
			return;
		}
		///End AVOID_ACCESS_m_vsPageNames_WHEN_NOT_READY
		
		string strWksName = make_book_sheet_name(m_vsPageNames[0], m_vsLayerNames[0]);
		Worksheet wks(strWksName);
		if(!wks)
			return;
		
		for(int ii = 0; ii < nSize; ii++)
		{
			int nDepCol = vnPositions[ vnDepDesigIndex[ii] ];
			findYColSetDesignation(wks, nDepCol, vnPositions, vnColDesignations);		
		}
		
	}
	///End ADD_LABEL_OR_ERR_INTO_EXSITING_PLOT
	
	void guessOtherColDesignations(vector<uint>& vnColDesignations, vector<int>& vnPositions)
	{		
		///Jasmine 04/14/09 AVOID_ACCESS_m_vsPageNames_WHEN_NOT_READY
		if(m_vsPageNames.GetSize() <= 0 || m_vsLayerNames.GetSize() <= 0)
		{
			ASSERT(0);
			return;
		}
		///End AVOID_ACCESS_m_vsPageNames_WHEN_NOT_READY
		
		string strWksName = make_book_sheet_name(m_vsPageNames[0], m_vsLayerNames[0]);
		Worksheet wks(strWksName);
		if(!wks)
			return;
		
		vector<uint> vnReorderIndexes;
		vnPositions.Sort(SORT_ASCENDING, TRUE, vnReorderIndexes);
		vnColDesignations.Reorder(vnReorderIndexes);
		
		vector<uint> vnMainDesigIndexes;
		int nSize = vnColDesignations.Find(vnMainDesigIndexes, mainDesigInPlot() );
		if(nSize < 1)
			return;
		
		bool b2DPlot 	= is2DPlot();
		bool bUseAutoX 	= false;
		for(int ii = 0; ii < nSize; ii++)
		{
			int nMainCol = vnPositions[ vnMainDesigIndexes[ii] ];
			//---Jasmine 09/27/08 QA80-12285-P2 USE_AUTO_X_IF_COL_IS_EVEN_SAMPLING
			Column col = wks.Columns(nMainCol);
			double dX0, dInc;
			if( col && col.IsEvenSampling(&dX0, &dInc) )
			{
				if(!bUseAutoX)
					bUseAutoX = checkAutoXasX(vnPositions, vnColDesignations);			
			}
			//---end
			else
				findXColSetDesignation(wks, nMainCol, vnPositions, vnColDesignations);
			
			if(b2DPlot)
				findYColSetDesignation(wks, nMainCol, vnPositions, vnColDesignations);
		}
	}
	//---Jasmine 09/27/08 QA80-12285-P2 USE_AUTO_X_IF_COL_IS_EVEN_SAMPLING
	bool checkAutoXasX(const vector<int>& vnPositions, vector<uint>& vnColDesignations)
	{
		int nRowNumberPosition = -1;
		vector<uint> vnIndexes;
		if(vnPositions.Find(vnIndexes, nRowNumberPosition) > 0 && vnColDesignations.GetSize() > vnIndexes[0])			
		{
			vnColDesignations[ vnIndexes[0] ] = COLDESIG_X;
			
			return true;
		}
		
		return false;
	}
	//---end
	uint mainDesigInPlot()
	{
		return is2DPlot()? COLDESIG_Z : COLDESIG_Y;
	}
	bool findXColSetDesignation(const Worksheet& wks, int nRefCol, const vector<int>& vnPositions, vector<uint>& vnColDesignations)
	{
		int nXCol = wks.FindColIndex(nRefCol, OKDATAOBJ_DESIGNATION_X);
		if(nXCol < 0)
			return false;
		
		vector<uint> vnIndexes;
		if(vnPositions.Find(vnIndexes, nXCol) > 0 && vnColDesignations.GetSize() > vnIndexes[0])			
		{
			vnColDesignations[ vnIndexes[0] ] = COLDESIG_X;
			return true;
		}
		
		return false;
	}
	bool findYColSetDesignation(const Worksheet& wks, int nRefCol, const vector<int>& vnPositions, vector<uint>& vnColDesignations)
	{
		int nYCol = wks.FindColIndex(nRefCol, OKDATAOBJ_DESIGNATION_Y);
		if(nYCol < 0)
			return false;
		
		vector<uint> vnIndexes;
		if(vnPositions.Find(vnIndexes, nYCol) > 0 && vnColDesignations.GetSize() > vnIndexes[0])			
		{
			vnColDesignations[ vnIndexes[0] ] = COLDESIG_Y;
			return true;
		}
		
		return false;
	}
#endif//CHANGE_DESIGNATION_MODE_BTN		
	///End AUTO_FIND_X_DESIGNATION
	
	///Jasmine 08/08/08 QA80-11974 DETECT_DESIGNATION_AND_AUTO_SHOW
	void showDesignationCol(const vector<uint>& vnColDesignations)
	{
		vector<uint> vecIndex;		
		bool bXErr = 0 < vnColDesignations.Find(vecIndex, COLDESIG_XERROR);
		//---Jasmine 11/28/08 v8.0980d QA80-12437 SHOULD_REMEMBER_DESIGNATION_AND_AUTO_DETECT_LATER
		//if(bXErr != m_chkXErrBars.Check)
		if(bXErr && bXErr != m_chkXErrBars.Check)
		//---
		{
			m_chkXErrBars.Check = bXErr;
			OnChangeErrBarOptions();
		}
			
		bool bYPlusErr = 0 < vnColDesignations.Find(vecIndex, COLDESIG_YPLUSERROR);
		bool bYMinusErr = 0 < vnColDesignations.Find(vecIndex, COLDESIG_YMINUSERROR);
		bool bCheck = bYPlusErr || bYMinusErr;
		//---Jasmine 11/28/08 v8.0980d QA80-12437 SHOULD_REMEMBER_DESIGNATION_AND_AUTO_DETECT_LATER
		if( bCheck || 0 < vnColDesignations.Find(vecIndex, COLDESIG_YERROR) )
		{
			if(bCheck != m_chkPosNegErrBars.Check)
			{
				m_chkPosNegErrBars.Check = bCheck;
				OnChangeErrBarOptions();
			}
		}
		//---
	}
	///End DETECT_DESIGNATION_AND_AUTO_SHOW
	///Kyle 07/24/08 SET_DEFAULT_SHOW_INFO_COLS
	void setDefaultHideCols(vector<byte> &vbColsDefault)
	{
		vbColsDefault.SetSize(m_flx.Cols);
		ASSERT( vbColsDefault.GetSize() == 1 + m_vnColDesignations.GetSize() + m_nInfoCols );		//the 1st Col is a blank for disregarded col designation
		vbColsDefault = false;
		vbColsDefault[m_nRadioColBegin] = true;		///Kyle 07/28/08 HIDE_THE_COL_OF_DISREGARDED_COL_DESIGNATION
		vbColsDefault[m_n1stDataValCol] =
		vbColsDefault[m_nUnitsCol] =
		//vbColsDefault[m_nCommentsCol] =
		vbColsDefault[m_nParaetersCol] =
		vbColsDefault[m_nUserParaCol] = true;
		
		vbColsDefault.RemoveAt(0, m_nRadioColEnd - m_nRadioColBegin + 1);///Jasmine 09/17/08 QA80-12186 DESIGNATION_COLUMN_SHOW_STATUS_ONLY_DEPEND_ON_PLOT_TYPE
	}
	///End SET_DEFAULT_SHOW_INFO_COLS
	///Kyle 07/24/08 CHANGE_THE_NAME_OF_USER_DEFINED_PARAMETERS
	void updateColHeading()
	{
		if(!m_bIsWksPages || m_vsPageNames.GetSize()<=0 || m_vsLayerNames.GetSize()<=0)
			return;
		
		///Jasmine 04/14/09 AVOID_ACCESS_m_vsPageNames_WHEN_NOT_READY
		if(m_vsPageNames.GetSize() <= 0 || m_vsLayerNames.GetSize() <= 0)
		{
			ASSERT(0);
			return;
		}
		///End AVOID_ACCESS_m_vsPageNames_WHEN_NOT_READY
		
		string strWksName = make_book_sheet_name(m_vsPageNames[0], m_vsLayerNames[0]);
		Worksheet wks(strWksName);
		if(wks)
		{
			Column col = wks.Columns( 0 );
			if(col)
			{
				vector<string> vsNames,vsValues;
				vector<uint> vecIndex;
				if (get_user_parameters(col, vsNames, vsValues, true)>0)
				{
					m_vsInfoCols[INFO_COL_USER_PARAM] = vsNames[0];
					SetColHeading(m_nUserParaCol, m_vsInfoCols[INFO_COL_USER_PARAM]);
					if(m_vnUnavailableInfoCols.Find(vecIndex, INFO_COL_USER_PARAM)>0)
						m_vnUnavailableInfoCols.RemoveAt(vecIndex[0]);
				}
				else
				{
					m_vsInfoCols[INFO_COL_USER_PARAM] = GetLocalized(E_STR_USER_DEFINED_PARAMETERS);
					SetColHeading(m_nUserParaCol, m_vsInfoCols[INFO_COL_USER_PARAM]);
					SetIsColHidden(m_nUserParaCol, true);
					if(m_vnUnavailableInfoCols.Find(vecIndex, INFO_COL_USER_PARAM)<=0)
						m_vnUnavailableInfoCols.Add(INFO_COL_USER_PARAM);
				}
			}
		}
	}
	void SetHiddenInfoCols()
	{
		m_vnUnavailableInfoCols.SetSize(0);
		if(!m_bIsWksPages)
		{
			m_vnUnavailableInfoCols.Add( INFO_COL_UNITS );
			m_vnUnavailableInfoCols.Add( INFO_COL_COMMENTS );
			m_vnUnavailableInfoCols.Add( INFO_COL_SAMPLING );
			m_vnUnavailableInfoCols.Add( INFO_COL_PARAMETERS );
			m_vnUnavailableInfoCols.Add( INFO_COL_USER_PARAM );
		}
	}
	///End CHANGE_THE_NAME_OF_USER_DEFINED_PARAMETERS
	
	bool isValidColDesignations()
	{
		Tree trTemp = NULL;
		return GetDataPlots(trTemp, true);
	}
	int guessPageType(LPCSTR lpcszName)
	{
		//---- CPY 3/5/04 QA70-5355 v7.5832 PLOT_SETUP_MULTISHEET_SUPPORT
		string strBookSheet = lpcszName;
		string strPage, strSheet;
		if(!get_book_sheet_names(strBookSheet, strPage, strSheet))
			strPage = lpcszName;
		//----
			
		Page  pg(strPage);
		if(pg)
			return pg.GetType();
		
		return EXIST_DATA;
	}
	bool updateRowNumberXFromAndStep(bool bCheckShowRow = false)
	{
		int nRow = getRowNumberRow();
		if(nRow > 0 && getFromStepColIndex() > 0)
		{
			int ii = getRowNumberRowArrayIndex(); //nRow - m_flx.FixedRows;
			m_vsColLongNames[ii] = getXFromStepStr();
			//----- CPY 8/17/03 ROW_NUMBER_ROW_IMPROVEMENT
			//m_flx.TextMatrix(nRow, m_nLabelCol) = m_vsColLongNames[ii];
			if(m_n1stDataValCol > 0)
				SetTextMatrix(nRow, getFromStepColIndex(), m_vsColLongNames[ii]);
			//-----
			///Jasmine 03/06/09 QA80-13219-P3 BRING_BACK_AUTO_X_MENU
			/////Jasmine 08/01/08 ALWAYS_SHOW_AUTOX_ROW_UNLESS_NOT_ALLOW
			///*
			if(bCheckShowRow && !m_chkAddRowNumX.Check)
			{
				m_chkAddRowNumX.Check = true;
				HideRow(nRow, false);
			}
			//*/
			/////End ALWAYS_SHOW_AUTOX_ROW_UNLESS_NOT_ALLOW
			///End BRING_BACK_AUTO_X_MENU
			return true;
		}
		return false;
	}
	bool updateRowNumbersRow()
	{
		int nRow = findRowNumberRow();
		if(nRow < 0 && !IsRowNumberRowAllowed())
			return false; // consistent, nothing to do
		
		if(nRow && !IsRowNumberRowAllowed()) // was added before, we need to just hide it
			m_chkAddRowNumX.Check = false;
		else if(nRow < 0) // no such row, so does not matter
			return false;
		///Jasmine 03/06/09 QA80-13219-P3 BRING_BACK_AUTO_X_MENU
		//else
			//m_chkAddRowNumX.Check = true;	///Jasmine 08/01/08 ALWAYS_SHOW_AUTOX_ROW_UNLESS_NOT_ALLOW
		///End BRING_BACK_AUTO_X_MENU
		
		if(m_chkAddRowNumX.Check)
		{
			updateDesigationRadio(nRow);
			//m_flx.RowHidden(nRow) = false;
			HideRow(nRow, false);
		}
		else
		{
			setDesignationRadioChoice(nRow, COLDESIG_NONE);
			//m_flx.RowHidden(nRow) = true;
			HideRow(nRow, true);
		}
		
		notifyDlgOnDesignationChanges();	///Jasmine 07/09/08 QA80-11817-P2 APPLY_DESIG_USE_ROW_NUM_ROW_AS_X_IF_NO_X_COL, call this function once desig change
		return true;
	}
	void updateListAfterChange(bool bApplyWks, bool bResetDesigationRadio, bool bResetGrid = false)
	{
		HOUR_GLASS
		
		if(bResetGrid)
			setupGridCols();

		updateColNameLabelsAndOtherInfo(bResetDesigationRadio);
		updateShowColsRows();
		
		if(bApplyWks)
			ApplyWksColDesignations();
		//ResizeCols(4);
		updateDesignations(true);
		notifyDlgOnDesignationChanges();

#ifdef CHANGE_DESIGNATION_MODE_BTN
		bool bHide = !m_bDesignation;
		hideDesignationColumns(bHide);	///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
#endif//CHANGE_DESIGNATION_MODE_BTN

		if(isAllowSortCols())
			m_flx.ExplorerBar = flexExSortShow;
		else
			m_flx.ExplorerBar = flexExNone;
	}	
	void updateColNameLabelsAndOtherInfo(bool bResetDesigationRadio = true)
	{			
		int nOffset = m_vsColNames.Find(STR_ROW_NUMBER) >= 0? 0: 1;
		int nRowNumber = 0;
		int nFixedRows = m_flx.FixedRows;
		m_flx.Rows = nFixedRows + m_vsColNames.GetSize();	
		///Jasmine 10/13/08 QA80-11938 SHOW_DESIGNATION_IN_SHORT_NAME_COLUMN
		vector<string> vsColNames;
		vsColNames = m_vsColNames;
#ifdef CHANGE_DESIGNATION_MODE_BTN	
		if(!m_bDesignation)
			vsColNames = m_vsColWithDesig;
#endif//CHANGE_DESIGNATION_MODE_BTN
		///End SHOW_DESIGNATION_IN_SHORT_NAME_COLUMN
		///Jasmine 04/14/09 AVOID_ACCESS_m_vsPageNames_WHEN_NOT_READY
		//for(int ii = 0, nRow = nFixedRows; ii < m_vsColNames.GetSize(); ii++, nRow++)
		for(int ii = 0, nRow = nFixedRows; ii < m_vsColNames.GetSize() && m_vsPageNames.GetSize() > 0; ii++, nRow++)
		///End AVOID_ACCESS_m_vsPageNames_WHEN_NOT_READY
		{
			vector<string> vsInfo;
			vsInfo.SetSize(m_nInfoCols);
			
			if(bResetDesigationRadio)
				SetRowData(nRow, COLDESIG_NONE);
			
			///Jasmine 10/13/08 QA80-11938 SHOW_DESIGNATION_IN_SHORT_NAME_COLUMN
			//m_flx.TextMatrix(nRow, m_nNameCol) = m_vsColNames[ii];
			SetTextMatrix(nRow, m_nNameCol, vsColNames[ii]);	
			///End SHOW_DESIGNATION_IN_SHORT_NAME_COLUMN
			if(m_nLabelCol > 0)
			{
				if(getRowNumberRow() == nRow)			
					SetTextMatrix(nRow, m_nLabelCol, STR_ROWNUM_ROW_LABEL); //----- CPY 8/17/03 ROW_NUMBER_ROW_IMPROVEMENT
				else
					SetTextMatrix(nRow, m_nLabelCol, m_vsColLongNames[ii]);
			}
			
			vsInfo[INFO_COL_INDEX] = (string)(ii + nOffset);
			
			///Jasmine 07/16/08 QA80-11817 COLUMN_INFO_CLASS
			//if(m_nIndexCol > 0)
				//m_flx.TextMatrix(nRow, m_nIndexCol) = getColPositionInWks(ii, m_vsColNames[ii]);
			//if(m_n1stDataValCol > 0)
				//m_flx.TextMatrix(nRow, m_n1stDataValCol) = get1stDataVal(m_vsColNames[ii]);
			string strWksName = make_book_sheet_name(m_vsPageNames[0], m_vsLayerNames[0]);
			Worksheet wks(strWksName);
			if(m_bIsWksPages && wks)//wks is valid but it's a matrix?
			{
				///Jasmine 09/24/08 WKS_COLUMNS_MAY_HAVE_SAME_NAME 
				//Column cc = wks.Columns( m_vsColNames[ii] );
				Column cc = getColumn(wks, m_vsColNames[ii], m_vsColLongNames[ii], ii - nRowNumber);
				///End WKS_COLUMNS_MAY_HAVE_SAME_NAME
				if(cc)
				{
					int nCount = m_ColInfo.GetInfo(vsInfo, cc);					
					ASSERT(nCount == m_nInfoCols);
				}
				else if(isRowNumber(m_vsColNames[ii]))
				{
					nRowNumber = 1;
					vsInfo[INFO_COL_INDEX] = "0";
					vsInfo[INFO_COL_1ST_DATA] = getXFromStepStr();
				}
			}
			
			if(m_nIndexCol > 0)
				SetTextMatrix(nRow, m_nIndexCol, vsInfo[INFO_COL_INDEX]);
			if(m_n1stDataValCol > 0)
				SetTextMatrix(nRow, m_n1stDataValCol, vsInfo[INFO_COL_1ST_DATA]);
			if(m_nSamplingCol > 0)	
				SetTextMatrix(nRow, m_nSamplingCol, vsInfo[INFO_COL_SAMPLING]);
			if(m_nCommentsCol > 0)	
				SetTextMatrix(nRow, m_nCommentsCol, vsInfo[INFO_COL_COMMENTS]);
			if(m_nUnitsCol > 0)	
				SetTextMatrix(nRow, m_nUnitsCol, vsInfo[INFO_COL_UNITS]);
			if(m_nParaetersCol > 0)	
				SetTextMatrix(nRow, m_nParaetersCol, vsInfo[INFO_COL_PARAMETERS]);
			if(m_nUserParaCol > 0)	
				SetTextMatrix(nRow, m_nUserParaCol, vsInfo[INFO_COL_USER_PARAM]);
			///End COLUMN_INFO_CLASS
		}
	}
	///Jasmine 09/24/08 WKS_COLUMNS_MAY_HAVE_SAME_NAME 
	Column getColumn(const Worksheet& wks, LPCSTR lpcszSName, LPCSTR lpcszLName, int nColBegin)
	{		
		int nFind = -1;
		for(int nCount = wks.GetNumCols(), ii = nColBegin; ii < nCount; ii++)
		{
			Column col = wks.Columns(ii);
			
			if(lstrcmp(col.GetName(), lpcszSName) != 0 || (lpcszLName && strlen(lpcszLName) > 0 && lstrcmp(col.GetLongName(), lpcszLName) != 0) )
				continue;
			
			nFind = ii;
			break;
		}
		
		Column colFind;
		if(nFind >= 0)
			colFind = wks.Columns(nFind);
		
		return colFind;
	}
	///End WKS_COLUMNS_MAY_HAVE_SAME_NAME
	void updateShowColsRows()
	{
		bool	bIsShowAll = m_chkShowAllCols.Check;
		
		int nFixedRows = m_flx.FixedRows;
		///Jasmine 09/24/08 GUI_CAN_SORT_AND_MAY_NOT_IN_SAME_ORDER_AS_m_vsColNames
		//for(int ii = 0, nRow = nFixedRows; ii < m_vsColNames.GetSize(); ii++, nRow++)
		//{
			//if(bIsShowAll || !isWksColHiddenOrDisregard(m_vsColNames[ii]))
		for(int nRow = nFixedRows; nRow < m_flx.Rows; nRow++)
		{
			int nIndex = getColumnIndex(nRow);
			//---Jasmine 09/27/08 QA80-12285-P3 GET_WRONG_COL_WITH_ROW_NUMBER_INDEX
			if( isRowNumber(nIndex) )
				continue;
			//---end
			
			///Sophy 8/24/2010 ORG-681-P7 PROPER_CLEAR_COLLIST_SETTINGS_WHEN_INCOMPATIBLE_PAGE_SELECTED
			//if(bIsShowAll || !isWksColHiddenOrDisregard(nIndex) )
			if ( bIsShowAll || (!isWksColHiddenOrDisregard(nIndex) && isWksColPlotable(nIndex)) )
			///end PROPER_CLEAR_COLLIST_SETTINGS_WHEN_INCOMPATIBLE_PAGE_SELECTED
		///End GUI_CAN_SORT_AND_MAY_NOT_IN_SAME_ORDER_AS_m_vsColNames				
				HideRow(nRow, false);
			else
			{
				HideRow(nRow, true);
				SetRowData(nRow, COLDESIG_NONE);
			}
		}
		updateRowNumbersRow();// must do this after updateShowAllCols which also HideShowRows
		
		///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
#ifdef CHANGE_DESIGNATION_MODE_BTN		
		if(!m_bDesignation)
		{
			for(int nRow = nFixedRows; nRow < m_flx.Rows; nRow++)
			{
				bool bPlotable = false;
				
				int nIndex = getColumnIndex(nRow); 
				
				///Jasmine 04/14/09 AVOID_ACCESS_m_vsPageNames_WHEN_NOT_READY
				//string strWksName = make_book_sheet_name(m_vsPageNames[0], m_vsLayerNames[0]);
				string strWksName;
				if(m_vsPageNames.GetSize() <= 0 || m_vsLayerNames.GetSize() <= 0)
					ASSERT(0);
				else
					strWksName = make_book_sheet_name(m_vsPageNames[0], m_vsLayerNames[0]);
				///End AVOID_ACCESS_m_vsPageNames_WHEN_NOT_READY
			
				if( isRowNumber(nIndex) )
				{
					bPlotable = false;
				}
				else if(m_bIsWksPages)
				{
					Worksheet wks(strWksName);
					if(wks)
					{
						Column cc = wks.Columns(nIndex);
						if(cc && isPlotable(cc) )
							bPlotable = true;
					}
				}
				else if(m_bIsMatrixPage)
				{
					bPlotable = is2DPlot();
				}
				else if(m_bIsFunctionPlots)
				{
					bPlotable = !is2DPlot();
				}
				else//loose dataset
				{
					///Sophy 8/3/2010 ORG-681-P2 PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG
					//bPlotable = !is2DPlot();
					if ( IsVirtualMatrix() )
						bPlotable = is2DPlot();
					else
						bPlotable = !is2DPlot();
					///end PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG
				}
				
				if(!bPlotable)
					HideRow(nRow, true);
			}
		}
#endif//CHANGE_DESIGNATION_MODE_BTN		
		///End DEFAULT_MODE_AUTO_GET_DESIGNATION
	}
	void countYs()
	{
		m_nYs = 0;
		m_nModifiers = 0;
		int nPos = m_strColPattern.Find('Y');
		while(nPos >= 0)
		{
			m_nYs++;
			nPos = m_strColPattern.Find('Y', nPos + 1);
		}
		// not all plot IDs has correct string, so some needed correction
		if(PCD_EXACT_ONE_GROUP & m_dwAuxTypeInfo) // the rest are modifiers
		{
			m_nYs = 1;
			m_nModifiers = 2;// XYXY, may need to be more general later
		}
	}
	bool hasEnoughYs(int nYs)
	{
		if(nYs < 1)
			return false;
		if(IS_PCD_EXACT_Y_COLS(m_dwAuxTypeInfo) && nYs != m_nYs)
			return false;
		if(IS_PCD_EXACT_Y_COLS_OR_ONE_LESS(m_dwAuxTypeInfo) && (nYs < m_nYs -1 || nYs > m_nYs))
			return false;
		
		return true;
	}
	bool hasTooManyYs(int nYs)
	{
		if(!IS_PCD_EXACT_Y_COLS_OR_MORE(m_dwAuxTypeInfo) && nYs > m_nYs)
			return true;
		return false;
	}
	void updatePlotType(int nNewPlotID, int nPageType, DWORD dwLayerBits)
	{
		//---- CPY 9/9/03 v7.5689 TERNARY_PLOT_USE_2D_TYPES
		//printf("id %d, dw %d, nLayer = %d\n", nNewPlotID, dwLayerBits, HIWORD(dwLayerBits));
		/*
		if(nNewPlotID)
			m_nPlotType	= Project.GetPlotTypeInfo(nNewPlotID, m_dwAuxTypeInfo, m_dwAuxPlotInfo, m_strColPattern);
		if(nPageType)
		{
			if(EXIST_DATA == nPageType || EXIST_FUNC_PLOT == nPageType)
				m_dwAuxTypeInfo &= ~PCD_CAN_ADD_E_H_L;
			if(EXIST_FUNC_PLOT == nPageType)
				m_dwAuxTypeInfo |= PCD_NO_X;
			
		}
		
		if (PCD_LAYER_TRI == dwLayerBits)
			m_dwAuxTypeInfo = PCD_LAYER_TRI | PCD_EXACT_YCOLS | PCD_Z_PREFER_Y | PCD_GROUP_MULTI_YS | PCD_PREFER_X | PCD_CAN_ADD_E_H_L | PCD_HIDE_ERR_BARS;
		else if (PCD_LAYER_SMITH == dwLayerBits)
			m_dwAuxTypeInfo |= PCD_HIDE_ERR_BARS;
		*/

		/// ML 12/3/2007 QA70-10661 P2 SWAPPED_POLAR_PLOT_SOME_PS_LC_WORK
		DWORD		dwAuxTypeInfoPreserve = m_dwAuxTypeInfo & PCD_POLAR_SWAPPED;
		/// end SWAPPED_POLAR_PLOT_SOME_PS_LC_WORK
		m_dwLayerBitsFromPlotTypeList = dwLayerBits; //CPY 8/1/2007 QA70-9867 POLAR_XY_SWITCHED_FOR_XYZ_CONTOUR
		//nNewPlotID can be 0, and get_plot_type_info will fix other bits, change m_nPlotType only if nNewPlotID is not zero  
		int nn = get_plot_type_info(nNewPlotID, nPageType, dwLayerBits, m_dwAuxTypeInfo, m_dwAuxPlotInfo, m_strColPattern);
		/// ML 12/3/2007 QA70-10661 P2 SWAPPED_POLAR_PLOT_SOME_PS_LC_WORK
		m_dwAuxTypeInfo |= dwAuxTypeInfoPreserve;
		/// end SWAPPED_POLAR_PLOT_SOME_PS_LC_WORK
		if(nn)
		{
			m_nPlotType = nn;
			countYs();
		}
		//----
	}
	void setupGridCols()
	{
		///Kyle 07/22/08 SET_NO_NEED_TO_REBUILD_M_FLX_FORMAT_STRING
		updateErrBarOptions();
		//m_dwAuxTypeInfo |= PCD_SHOW_X_ERR;
		//m_dwAuxTypeInfo |= PCD_SHOW_POS_NEG_ERR;
		///End SET_NO_NEED_TO_REBUILD_M_FLX_FORMAT_STRING
//		out_int("Plot type = ", m_nPlotType);
		if(!Project.GetPlotDesignations(m_nPlotType, m_dwAuxTypeInfo, m_strColPattern, m_vnColDesignations))
			m_vnColDesignations.SetSize(0);	
		prepareGridColumns();		
	}
	void updateErrBarOptions()
	{
		m_dwAuxTypeInfo &= ~(PCD_SHOW_X_ERR | PCD_SHOW_POS_NEG_ERR);
		if(IsAllowErrbars())//(m_dwAuxTypeInfo & PCD_CAN_ADD_E_H_L)
		{
			if(m_chkXErrBars.Check)
				m_dwAuxTypeInfo |= PCD_SHOW_X_ERR;
			if(m_chkPosNegErrBars.Check)
				m_dwAuxTypeInfo |= PCD_SHOW_POS_NEG_ERR;
		}
	}
	void updateDesignations(bool bResizeCols = false)
	{
		int nR1 = m_flx.FixedRows;
		int nR2 = m_flx.Rows;
		for(int nRow = nR1; nRow < nR2; nRow++)
			updateDesigationRadio(nRow);
	
		if(bResizeCols)
			updateColWidths();
	}
	void updateDesigationRadio(int nRow) // update check box according to RowData
	{
		int nDesig = GetRowData(nRow);
		int nRadioChoice = getDesignationRadioChoice(nDesig);
				
		for(int nCol = m_nRadioColBegin, nRadio = 0; nCol <= m_nRadioColEnd; nCol++, nRadio++)
		{
			if(nRadioChoice == nRadio)
				SetTextMatrix(nRow, nCol, "1");
			else
				SetTextMatrix(nRow, nCol, "0");
		}
		
		if(nDesig != COLDESIG_NONE && isSingleDesignation(nDesig))
			checkSingleDesignationForAllRows(nRow, nDesig);
	}
	//only 1 X is allowed, we may relax this later
	checkSingleDesignationForAllRows(int nRowNewChange, int nDesignationToCheck)
	{
		int nDesig = GetRowData(nRowNewChange);
		if(nDesignationToCheck == nDesig)
		{
			int nR1 = m_flx.FixedRows;
			int nR2 = m_flx.Rows;
			int nD;
			for(int nRow = nR1; nRow < nR2; nRow++)
			{
				if(nRowNewChange == nRow)
					continue;
				nD = GetRowData(nRow);
				if(nDesignationToCheck == nD)
				{
					SetRowData(nRow, COLDESIG_NONE);
					updateDesigationRadio(nRow);
				}
			}
		}
	}
	bool isAllowSortCols()
	{
		DWORD dwModifierBits = PCD_MODIFIER_SIZE|PCD_MODIFIER_COLOR|PCD_MODIFIER_VEC_AM|PCD_MODIFIER_VEC_XYEND;
		if(m_dwAuxTypeInfo & dwModifierBits)
			return false;

		//---- CPY 9/10/03 v7.5690 HI_LO_CLOSE_FLOAT_COLS
		if(m_nYs > 1 && (m_dwAuxTypeInfo & PCD_EXACT_YCOLS))
			return false;
		//----
		return true;
	}
	bool isSingleDesignation(int nDesig) // between rows in table
	{
		if(COLDESIG_X == nDesig)
			return true;
		if(nDesig >= COLDESIG_SIZE) // all modifier does not make sense to have more then one
			return true;
		if(m_dwAuxTypeInfo & PCD_EXACT_ONE_GROUP)
			return true;
		
		return false;
	}
	int getFromStepColIndex()
	{
		return m_n1stDataValCol;
	}
	string getXFromStepStr()
	{
		string str;
		cvt_x_from_step_to_str(m_RowNumberXFrom, m_RowNumberXStep, str.GetBuffer(MAXLINE), MAXLINE);
		str.ReleaseBuffer();
		return str;
	}
	bool setXFromStepStr(LPCSTR lpcsz, bool bCheckShowRow = true) // must be in the form of 123/456
	{
		//---- CPY 4/17/07 QA70-9625 EVEN_SPACED_X_PLOL_DEFAULT_TO_USE_COL_SETTINGS
		/*
		string str = lpcsz;
		int nPos = str.Find('/');
		if(nPos > 0 && nPos < str.GetLength())
		{
			string strFrom = str.Left(nPos);
			string strStep = str.Mid(nPos+1);
			m_RowNumberXFrom = atof(strFrom);
			m_RowNumberXStep = atof(strStep);
			updateRowNumberXFromAndStep(bCheckShowRow);
			return true;
		}
		*/
		///Jasmine 07/09/08 QA80-11817-P3 FAIL_TO_PARSE_AUTO_IN_PLOT_STRING
		//if(okutil_get_even_spaced_x_from_str(lpcsz, &m_RowNumberXFrom, &m_RowNumberXStep))
		if( !okutil_get_even_spaced_x_from_str(lpcsz, &m_RowNumberXFrom, &m_RowNumberXStep) )
		{
			m_RowNumberXFrom = m_RowNumberXStep = NANUM;
		}
		//End FAIL_TO_PARSE_AUTO_IN_PLOT_STRING
		{
			updateRowNumberXFromAndStep(bCheckShowRow);
			return true;
		}
		//---- EVEN_SPACED_X_PLOL_DEFAULT_TO_USE_COL_SETTINGS
		return false;
	}
	int getRowNumberRowArrayIndex()
	{
		return 0; // this should never changed
	}
	int findRowNumberRow()
	{
		return FindRow(STR_ROW_NUMBER, m_nNameCol);
	}
	int getRowNumberRow(bool bCheckSort = true)
	{
		// there is some inconsistency sometimes, so PCD_NO_X is not always present
		if(!IsRowNumberRowAllowed())
			return -1;
		
		//----- CPY 8/20/03, Row# row can be sorted out
		if(bCheckSort && isAllowSortCols())
			return findRowNumberRow();	
		else
			return m_flx.FixedRows;
		//-----
	}
	bool isXCol(int nCol)
	{
		if(!isColDesignationInList(COLDESIG_X))
			return false;
	
		// if X, must be 1
		if(1==nCol)
			return true;

		return false;
	}
	int getDesignationRadioChoice(int nDesignation)
	{
		int nRadioChoice = 0;
		for(int ii = 0; ii < m_vnColDesignations.GetSize(); ii++)
		{
			if(nDesignation == m_vnColDesignations[ii])
			{
				nRadioChoice = ii + 1;// disregard not in designation list
				break;
			}
		}
		return nRadioChoice;
	}
	int getDesignationOfCol(int nCol) // return -1 if not one of Col Designations Cols
	{
		// disregard not in designation list
		if(nCol < 0 || nCol > m_vnColDesignations.GetSize()) 
			return -1;
		
		if(0 == nCol)
			return COLDESIG_NONE;
		
		return m_vnColDesignations[nCol-1];
	}
	bool setDesignation(int nRow, int nDesig, bool bCheckInList = true)
	{
		if(bCheckInList && !isColDesignationInList(nDesig))
			return false;
		SetRowData(nRow, nDesig);
		return true;
	}
	bool setDesignationRadioChoice(int nRow, int nChoice)
	{
		int nDesig = COLDESIG_NONE;
		if(nChoice > 0 && nChoice <= m_vnColDesignations.GetSize())
			nDesig = m_vnColDesignations[nChoice-1];
		//--- CPY 9/15/03, SET_ALL_TO_TOP_NO_PLOT
		if(getRowNumberRow() == nRow && nDesig > COLDESIG_X)
			return false;
		//---
		int nOldDesignation = getColDesignation(nRow);
		//m_flx.RowData(nRow) = nDesig;
		setDesignation(nRow, nDesig, false);
		if(nChoice)
		{
			if(!isValidColDesignations())
			{
				setDesignation(nRow, nOldDesignation, false);
				return false;
			}
		}
		return true;
	}
	int getColDesignation(int nRow)
	{
		if(nRow < m_flx.FixedRows)
			return -1;
		
		int nDesig = GetRowData(nRow);
		return nDesig;
	}
	///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
#ifdef CHANGE_DESIGNATION_MODE_BTN	
	int getColDesignationFromColType(int nRow)
	{
		int nDesig = COLDESIG_NONE;
		if( GetIsSelected(nRow) && !GetIsRowHidden(nRow) ) //temp, for wks only
		{
			int nIndex = getColumnIndex(nRow);
			
			///Jasmine 04/14/09 AVOID_ACCESS_m_vsPageNames_WHEN_NOT_READY
			//string strWksName = make_book_sheet_name(m_vsPageNames[0], m_vsLayerNames[0]);
			string strWksName;
			if(m_vsPageNames.GetSize() <= 0 || m_vsLayerNames.GetSize() <= 0)
				ASSERT(0);
			else
				strWksName = make_book_sheet_name(m_vsPageNames[0], m_vsLayerNames[0]);
			///End AVOID_ACCESS_m_vsPageNames_WHEN_NOT_READY
		
			if( isRowNumber(nIndex) )
				nDesig = COLDESIG_NONE;
			else if(m_bIsWksPages)
			{
				Worksheet wks(strWksName);
				if(wks)
				{
					Column cc = wks.Columns(nIndex);
					if(cc)
					{
						nDesig = colTypeToColDesignation(cc.GetType());
					}
				}
			}
			else if(m_bIsMatrixPage)
				nDesig = COLDESIG_Z;
			else if(m_bIsFunctionPlots)
				nDesig = COLDESIG_Y;
			else//loose dataset
			{
				if ( IsVirtualMatrix() )
				{
					nDesig = COLDESIG_Z;
				}
				else
					nDesig = COLDESIG_Y;
			}
		}	
		
		return nDesig;
	}
#endif//CHANGE_DESIGNATION_MODE_BTN
	///End DEFAULT_MODE_AUTO_GET_DESIGNATION
	
	// assume vnColDesignations and vnPositions empty on entering function
	bool getColDesignations(vector<uint>& vnColDesignations, vector<int>& vnPositions)
	{
		int nR1 = m_flx.FixedRows;
		int nR2 = m_flx.Rows;
		for(int nRow = nR1; nRow < nR2; nRow++)
		{
			///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION		
			int nDesig;
#ifdef CHANGE_DESIGNATION_MODE_BTN	
			if(!m_bDesignation)	
				nDesig = getColDesignationFromColType(nRow);
			else
#endif//CHANGE_DESIGNATION_MODE_BTN
				nDesig = getColDesignation(nRow);//m_flx.RowData(nRow);
			///End DEFAULT_MODE_AUTO_GET_DESIGNATION
			
			vnColDesignations.Add(nDesig);
			vnPositions.Add( getColumnIndex(nRow) );//atoi(GetCell(nRow, m_nIndexCol));// grid might have been sorted
		}
		
		///Jasmine 09/17/08 QA80-11938 AUTO_FIND_X_DESIGNATION
#ifdef CHANGE_DESIGNATION_MODE_BTN	
		if(!m_bDesignation && m_bIsWksPages)	
		{	
			///Jasmine 11/21/08 v8.0978b QA80-11938 ADD_LABEL_OR_ERR_INTO_EXSITING_PLOT	
			guessMainDesigCol(vnColDesignations, vnPositions);
			///End ADD_LABEL_OR_ERR_INTO_EXSITING_PLOT
			
			guessOtherColDesignations(vnColDesignations, vnPositions);
		
		}
#endif//CHANGE_DESIGNATION_MODE_BTN		
		///End AUTO_FIND_X_DESIGNATION
		return true;
	}
	int countDesignations(int nDesig)
	{
		int nR1 = m_flx.FixedRows;
		int nR2 = m_flx.Rows;
		int nCount = 0;
		for(int nRow = nR1; nRow < nR2; nRow++)
		{
			if(getColDesignation(nRow) == nDesig)
				nCount++;
		}
		return nCount;
	}
	int countModifiers()
	{
		int nR1 = m_flx.FixedRows;
		int nR2 = m_flx.Rows;
		int nCount = 0;
		int nDesig;
		for(int nRow = nR1; nRow < nR2; nRow++)
		{
			nDesig = getColDesignation(nRow);
			if(nDesig >= COLDESIG_SIZE)
				nCount++;
		}
		return nCount;
	}	
	void prepareGridColumns()
	{
		string str = " ";// begin 1st Col with a blank for disregarded col designation
		for(int ii = 0; ii < m_vnColDesignations.GetSize(); ii++)
		{
			str += "|";
			str += getColDesignationName(m_vnColDesignations[ii]);
		}
		//m_nYError = m_nYPlusError;		///Kyle 07/22/08 SET_NO_NEED_TO_REBUILD_M_FLX_FORMAT_STRING
		m_nRadioColBegin = 0;
		m_nRadioColEnd = ii;
		
		///Jasmine 07/16/08 QA80-11817 COLUMN_INFO_CLASS
		//addColHeading(str, nInfoCol++);// there is still that 1st col with disregard
		markInfoColIndexes( getInfoColBeginIndex() );
		
		string strInfoCols;
		int nSize = strInfoCols.SetTokens(m_vsInfoCols, '|');
		ASSERT(nSize == m_nInfoCols);
		str += "|" + strInfoCols;
		///End COLUMN_INFO_CLASS
		
		m_flx.FormatString = str;
		m_flx.Cols = ii + 1 + m_nInfoCols;
		int nCol;
		for(nCol = m_nRadioColBegin; nCol <= m_nRadioColEnd; nCol++)
		{
			SetColDataType(nCol, flexDTBoolean);
			SetColAlignment(nCol, flexAlignCenterCenter);
		}
		
		for(nCol = getInfoColBeginIndex(); nCol <m_flx.Cols; nCol++)
		{
			SetColDataType(nCol, flexDTString);
			SetColAlignment(nCol, flexAlignLeftCenter);
		}
		//1st Data Value can be numeric or string, it's better not set its DataType
		SetColDataType(m_n1stDataValCol, flexDTEmpty);
		SetColAlignment(m_n1stDataValCol, flexAlignGeneral);
		///Jasmine 04/16/07 QA70-9632 INDEX_COLUMN_DATA_TYPE_SHOULD_BE_NUMERIC
		SetColDataType(m_nIndexCol, flexDTDouble);
		SetColAlignment(m_nIndexCol, flexAlignRightCenter);
		///End INDEX_COLUMN_DATA_TYPE_SHOULD_BE_NUMERIC
		
		SetIsColHidden(m_nRadioColBegin, true); // Joe etc suggested that disregard radio col can be left out
		
		HideInfoCols();			///Kyle 07/30/08 HIDE_INFO_COLS_THROUGH_THE_HIDDEN_LIST
		
		updateColNameColHeading();
	}
	///Kyle 07/30/08 HIDE_INFO_COLS_THROUGH_THE_HIDDEN_LIST
	void HideInfoCols()
	{
		vector<uint> vecIndex;
		for(int ii = 0, nInfoCol = getInfoColBeginIndex(); ii < m_nInfoCols; ii++, nInfoCol++)
		{
			if(m_vnUnavailableInfoCols.Find(vecIndex, ii)>0)//in N/A list
				SetIsColHidden(nInfoCol, true);
			else
				SetIsColHidden(nInfoCol, !m_vbInfoColsShow[ii]);
		}
	}
	///End HIDE_INFO_COLS_THROUGH_THE_HIDDEN_LIST
	///Jasmine 07/16/08 QA80-11817 MORE_COLUMN_INFO_AND_CHECK_MENU
	int getInfoTypes(vector<uint>& vnInfo)
	{
		vnInfo.SetSize(0);
		for(int nTypeEnum = INFO_COL_BEGIN; nTypeEnum <= INFO_COL_END; nTypeEnum++)
		{
			switch(nTypeEnum)
			{
			case INFO_COL_NAME:
				vnInfo.Add(COL_INFO_SNAME);
				break;
			case INFO_COL_LONGNAME:
				vnInfo.Add(COL_INFO_LNAME);
				break;
			case INFO_COL_INDEX:					//--CPY 8/6/03 ADD_COL_POSITION_IN_WKS
				vnInfo.Add(COL_INFO_INDEX);
				break;			
			case INFO_COL_1ST_DATA:
				vnInfo.Add(COL_INFO_1ST_VALUE);
				break;
			case INFO_COL_SAMPLING:
				vnInfo.Add(COL_INFO_SAMPLING_INTERVAL);
				break;
			case INFO_COL_UNITS:
				vnInfo.Add(COL_INFO_UNITS);
				break;
			case INFO_COL_COMMENTS:
				vnInfo.Add(COL_INFO_COMMENTS);
				break;
			case INFO_COL_PARAMETERS:
				vnInfo.Add(COL_INFO_PARAMETERS);
				break;
			case INFO_COL_USER_PARAM:
				vnInfo.Add(COL_INFO_USER_PARAME);
				break;
			default:
				ASSERT(FALSE);
				break;
			}
		}
		int nSize 			= vnInfo.GetSize();
		ASSERT(nSize == INFO_COL_END-INFO_COL_BEGIN+1);
		return nSize;
	}
	int markInfoColIndexes(int nBegin)
	{
		for(int nTypeEnum = INFO_COL_BEGIN; nTypeEnum <= INFO_COL_END; nTypeEnum++)
		{
			switch(nTypeEnum)
			{
			case INFO_COL_NAME:
				m_nNameCol = nBegin + nTypeEnum;
				break;
			case INFO_COL_LONGNAME:
				m_nLabelCol = nBegin + nTypeEnum;
				break;
			case INFO_COL_INDEX:					//--CPY 8/6/03 ADD_COL_POSITION_IN_WKS
				m_nIndexCol = nBegin + nTypeEnum;
				break;			
			case INFO_COL_1ST_DATA:
				m_n1stDataValCol = nBegin + nTypeEnum;
				break;
			case INFO_COL_SAMPLING:
				m_nSamplingCol = nBegin + nTypeEnum;
				break;
			case INFO_COL_UNITS:
				m_nUnitsCol = nBegin + nTypeEnum;
				break;
			case INFO_COL_COMMENTS:
				m_nCommentsCol = nBegin + nTypeEnum;
				break;
			case INFO_COL_PARAMETERS:
				m_nParaetersCol = nBegin + nTypeEnum;
				break;
			case INFO_COL_USER_PARAM:
				m_nUserParaCol = nBegin + nTypeEnum;
				break;
			default:
				ASSERT(FALSE);
				break;
			}
		}
		ASSERT(nTypeEnum == m_nInfoCols);
		int nLast = nBegin + (nTypeEnum - 1);
		return nLast;
	}
	///End MORE_COLUMN_INFO_AND_CHECK_MENU
	string getColHeadingTooltips(int nCol);
	
	bool isRowNumber(LPCSTR lpcszColName)
	{
		return lstrcmpi(lpcszColName, STR_ROW_NUMBER) == 0? true:false;
	}
	///Jasmine 09/24/08 WKS_COLUMNS_MAY_HAVE_SAME_NAME
	bool isRowNumber(int nIndex){return 0 > nIndex;}
	int getColumnIndex(int nRow){return  atoi( GetCell(nRow, m_nIndexCol) )-1;}
	///End WKS_COLUMNS_MAY_HAVE_SAME_NAME
	/*string getColPositionInWks(int nIndex, LPCSTR lpcszColName)
	{
		string str = nIndex + 1;// 1 offset
		//printf("1st wks is %s\n", m_vsPageNames[0]);
		///Jasmine 03/28/07 CHANGE_INCORRECT_CODE_TO_GET_WKS
		//Worksheet wks(m_vsPageNames[0]);
		string strWksName = make_book_sheet_name(m_vsPageNames[0], m_vsLayerNames[0]);
		Worksheet wks(strWksName);
		///End CHANGE_INCORRECT_CODE_TO_GET_WKS
		if(wks)
		{
			Column cc = wks.Columns(lpcszColName);
			if(cc)
				str = cc.GetIndex() + 1; // 1 offset
			else if(isRowNumber(lpcszColName))
				str = 0;
		}
		return str;
	}
	
	string get1stDataVal(LPCSTR lpcszColName)
	{
		string str;
		///Jasmine 03/28/07 CHANGE_INCORRECT_CODE_TO_GET_WKS
		//Worksheet wks(m_vsPageNames[0]);
		string strWksName = make_book_sheet_name(m_vsPageNames[0], m_vsLayerNames[0]);
		Worksheet wks(strWksName);
		///End CHANGE_INCORRECT_CODE_TO_GET_WKS
		if(wks)
		{
			Column cc = wks.Columns(lpcszColName);
			if(cc)
			{
				int nRow = cc.GetLowerBound();
				int nCol = cc.GetIndex();
				wks.GetCell(nRow, nCol, str);
			}
			else if(isRowNumber(lpcszColName))
				str = getXFromStepStr();
		}
		return str;
	}*/
	bool isWksColHiddenOrDisregard(int nIndex)
	{
		///Jasmine 03/28/07 CHANGE_INCORRECT_CODE_TO_GET_WKS
		//Worksheet wks(m_vsPageNames[0]);
		
		///Jasmine 04/14/09 AVOID_ACCESS_m_vsPageNames_WHEN_NOT_READY
		if(m_vsPageNames.GetSize() <= 0 || m_vsLayerNames.GetSize() <= 0)
		{
			ASSERT(0);
			return false;
		}
		///End AVOID_ACCESS_m_vsPageNames_WHEN_NOT_READY
			
		string strWksName = make_book_sheet_name(m_vsPageNames[0], m_vsLayerNames[0]);
		Worksheet wks(strWksName);
		///End CHANGE_INCORRECT_CODE_TO_GET_WKS
		if(wks)
		{
			Column cc = wks.Columns(nIndex);
			if(cc)
			{
				if(cc.Show==0 || cc.GetType() == OKDATAOBJ_DESIGNATION_NONE)
					return true;
			}
		}
		return false;
	}
	
	///Sophy 8/24/2010 ORG-681-P7 PROPER_CLEAR_COLLIST_SETTINGS_WHEN_INCOMPATIBLE_PAGE_SELECTED
	bool isWksColPlotable(int nIndex)
	{
		if(m_vsPageNames.GetSize() <= 0 || m_vsLayerNames.GetSize() <= 0)
		{
			ASSERT(0);
			return false;
		}
		if ( m_bIsWksPages )
		{
			string strWksName = make_book_sheet_name(m_vsPageNames[0], m_vsLayerNames[0]);
			Worksheet wks(strWksName);
			if ( wks )
			{
				Column cc(wks, nIndex);
				if ( cc )
				{
					///Sophy 8/25/2010 ORG-681-P8 PROPER_CLEAR_COLLIST_SETTINGS_WHEN_INCOMPATIBLE_PAGE_SELECTED
					if ( PCD_ONLY_ONE_Z & m_dwAuxTypeInfo )
						return !is2DPlot();
					
					if ( !m_bDesignation )
						return isPlotable(cc);
					///end PROPER_CLEAR_COLLIST_SETTINGS_WHEN_INCOMPATIBLE_PAGE_SELECTED
					///Sophy 8/27/2010 ORG-681-P9 PROPER_CLEAR_COLLIST_SETTINGS_WHEN_INCOMPATIBLE_PAGE_SELECTED
					else
						return true;
					///end PROPER_CLEAR_COLLIST_SETTINGS_WHEN_INCOMPATIBLE_PAGE_SELECTED
				}
				return false;
			}
		}
		else if ( m_bIsMatrixPage )
			return is2DPlot();
		else if ( m_bIsFunctionPlots )
			return !is2DPlot();
		else
		{
			if ( IsVirtualMatrix() )
				return is2DPlot();
			else
				return !is2DPlot();
		}
		return false;
	}
	///end PROPER_CLEAR_COLLIST_SETTINGS_WHEN_INCOMPATIBLE_PAGE_SELECTED
//protected:
public:
	virtual string GetRuntimeClass()
	{
		return "ColListControl";
	}
	virtual int GetDefaultSize(){return 178;}

	////------------------ vsFlex events
	void OnAfterEdit(Control flxControl, int nRow, int nCol)
	{
		OnAfterEdit(nRow, nCol);
	}
	//virtual 
	void OnAfterEdit(int nRow, int nCol)
	{
		GridListControl::OnAfterEdit(nRow, nCol);
		bool bSetOK = true;
		int nVal = GetCell(flexcpText, nRow, nCol);
		if(nVal)
		///Kyle 07/31/08 SET_ROW_NUM_ROW_AS_DEFAULT_X_IF_NO_X_ASSIGNED
			//bSetOK = setDesignationRadioChoice(nRow, nCol - m_nRadioColBegin);
		{
			int nChoice =  nCol - m_nRadioColBegin;
			bSetOK = setDesignationRadioChoice(nRow, nChoice);
			int nDesig = COLDESIG_NONE;
			if(nChoice > 0 && nChoice <= m_vnColDesignations.GetSize())
				nDesig = m_vnColDesignations[nChoice-1];
			string strSampling = GetTextMatrix(nRow, m_nSamplingCol);
			if( nDesig==COLDESIG_Y && bSetOK && !strSampling.IsEmpty() )	//assigned as y & sampling interval exist
				SetRowNumberRowAsDefaultX();
		}
		///End SET_ROW_NUM_ROW_AS_DEFAULT_X_IF_NO_X_ASSIGNED
		else
			setDesignationRadioChoice(nRow, 0);// always OK to clear
		
		updateDesigationRadio(nRow);
		if(bSetOK)
			notifyDlgOnDesignationChanges();
	}	
	void OnBeforeEdit(Control cntrl, long nRow, long nCol, BOOL* pCancel)
	{
		if(nRow > 0 && nRow == getRowNumberRow())
		{
			if(nCol == getFromStepColIndex())
			{
				///Jasmine 07/09/08 QA80-11817-P3 PLOT_ALWAYS_USE_SAMPLING_INTERVAL_AS_X_IF_AVAILABLE, not use From/Step any more
				//m_flx.ComboList = "...";	
				*pCancel = true;
				///End PLOT_ALWAYS_USE_SAMPLING_INTERVAL_AS_X_IF_AVAILABLE
				return;
			}
			//----- CPY 8/17/03 ROW_NUMBER_ROW_IMPROVEMENT CPY 8/17/03 ROW_NUMBER_ROW_ONLY_X_ALLOWED
			else if(!isXCol(nCol))// for Row number col, only X is allowed
			{
				*pCancel = true;
				return;
			}
			//----- end	
		}
		string str = m_flx.ComboList;
		/// Hong 10/13/10 ORG-35 FIX_ORIGIN_CRASH_WITH_NEW_GRID
#ifdef		__REPLACE_VSFLEX_WITH_64_MP_WXGRID__
		if ( !str.IsEmpty() )
#else		//__REPLACE_VSFLEX_WITH_64_MP_WXGRID__
		/// end FIX_ORIGIN_CRASH_WITH_NEW_GRID
		if(!str.Empty())
#endif		//__REPLACE_VSFLEX_WITH_64_MP_WXGRID__ /// Hong 10/13/10 ORG-35 FIX_ORIGIN_CRASH_WITH_NEW_GRID
		{
			str.Empty();
			m_flx.ComboList = str;
		}
		
		if(nCol < m_nRadioColBegin || nCol > m_nRadioColEnd)
			*pCancel = TRUE;
	}
	void OnButtonClick(Control flxControl, int nRow, int nCol)
	{
		if(nRow > 0 && nRow == getRowNumberRow() && nCol == getFromStepColIndex())
		{
			RECT r1;
			GetCellRect(nRow, nCol, r1, true, true);
			s_nLeft = r1.left + RECT_WIDTH(r1)/2;
			s_nTop = r1.top + RECT_HEIGHT(r1)/2;

			GETN_BOX(trTemp)
			GETN_NUM(xFrom, _LC("X From", _CAT), m_RowNumberXFrom)
			GETN_NUM(xStep, _LC("X Step", _CAT), m_RowNumberXStep)
			if(GetNBox(trTemp, SCP_DLG_X_ROW_NUM_TITLE, SCP_DLG_X_ROW_NUM_LABEL, NULL, get_n_box_event, GetDlgSafeHwnd()))
			{
				m_RowNumberXFrom = trTemp.xFrom.dVal;
				m_RowNumberXStep = trTemp.xStep.dVal;
				updateRowNumberXFromAndStep();
				updateColWidths();
			}
		}
	}

	// nButton = MK_LBUTTON	etc
	// nShift = 1 if shift, 0 if not
	void OnBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel);
	
	void OnMouseMove(Control cntrl, short nButton, short nShift, float X, float Y)
	{
		string strTooltips;
		int nRow, nCol;
		if(!GetMouseCell(nRow, nCol))
			return;
		
		if(!IsColHeadingRow(nRow))
			return;
		
		strTooltips = getColHeadingTooltips(nCol);
		SetToolTipsText(strTooltips);
	}
	////------------------	
	
	///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
#ifdef CHANGE_DESIGNATION_MODE_BTN	
	void OnColSelChange()
	{
		if(!m_bDesignation)
			notifyDlgOnDesignationChanges();
	}
#endif//CHANGE_DESIGNATION_MODE_BTN
	///End DEFAULT_MODE_AUTO_GET_DESIGNATION
	
private:
	///Kyle 07/31/08 SET_ROW_NUM_ROW_AS_DEFAULT_X_IF_NO_X_ASSIGNED
	bool SetRowNumberRowAsDefaultX()
	{
		int nRow = getRowNumberRow();
		if(nRow<0)
			return false;
		int nDesig = COLDESIG_X;
		if(	countDesignations(nDesig) > 0)
			return false;
		///Jasmine 03/06/09 QA80-13219-P3 BRING_BACK_AUTO_X_MENU
		/////Jasmine 08/01/08 ALWAYS_SHOW_AUTOX_ROW_UNLESS_NOT_ALLOW
		///*
		if(!m_chkAddRowNumX.Check)
		{
			m_chkAddRowNumX.Check = true;
			OnChangeAddRowNumbers();
		}
		//*/
		/////End ALWAYS_SHOW_AUTOX_ROW_UNLESS_NOT_ALLOW
		///End BRING_BACK_AUTO_X_MENU
		bool bSetOK = setDesignation(nRow, nDesig);
		updateDesigationRadio(nRow);
		return bSetOK;
	}
	///End SET_ROW_NUM_ROW_AS_DEFAULT_X_IF_NO_X_ASSIGNED
	//
	void notifyDlgOnDesignationChanges()
	{
		PostDlgMessage(WM_USER_ON_CONTROL_CHANGE, ON_CONTROL_CHANGE_COL_DESIGNATIONS, 0);			
	}
	void updateWksPageNames(const vector<string>& vsWksPageNames, int nPageType)
	{
		m_bIsVirtualMatrix = false;	///Sophy 8/19/2010 ORG-681-P6 PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG
		m_bIsWksPages = m_bIsMatrixPage = m_bIsFunctionPlots = false;
		if(EXIST_WKS == nPageType || EXIST_EXTERN_WKS == nPageType)
			m_bIsWksPages = true;
		else if(EXIST_MATRIX == nPageType)
			m_bIsMatrixPage = true;
		else if(EXIST_FUNC_PLOT == nPageType)
			m_bIsFunctionPlots = true;
		///Sophy 8/3/2010 ORG-681-P2 PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG
		else
		{
			if ( vsWksPageNames.GetSize() > 0 && okutil_is_virtual_matrix(vsWksPageNames[0]) )
				m_bIsVirtualMatrix = true;
			else
				m_bIsVirtualMatrix = false;
		}
		///end PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG
		
		//---- CPY 3/5/04 QA70-5355 v7.5832 PLOT_SETUP_MULTISHEET_SUPPORT
		//vsWksPageNames = [BookName]Sheet, or just pagename
		//	m_vsPageNames = vsWksPageNames;
		//	m_vsLayerNames.SetSize(m_vsPageNames.GetSize());
		//	for(int ii = 0; ii < m_vsLayerNames.GetSize(); ii++)
		//		m_vsLayerNames[ii].Empty();
		m_vsPageNames = vsWksPageNames;
		m_vsLayerNames = vsWksPageNames;
		for(int ii = 0; ii < m_vsLayerNames.GetSize(); ii++)
		{
			string strBook, strSheet;
			if(get_book_sheet_names(vsWksPageNames[ii], strBook, strSheet))
			{
				m_vsPageNames[ii] = strBook;
				m_vsLayerNames[ii] = strSheet;
			}
			else
				m_vsLayerNames[ii].Empty();
		}
		//----
		// only wks page we will remember the page name, all others we will use full dataset names so keep page name empty to indicate such
		if(!m_bIsWksPages && !m_bIsMatrixPage)
		{
			for(int ii = 0; ii < m_vsPageNames.GetSize(); ii++)
				m_vsPageNames[ii].Empty();
			
			//CPY 8/5/03, we also need to make sure only one, otherwise internal code will generate multiple plots
			m_vsPageNames.SetSize(1);
			m_vsLayerNames.SetSize(1);
		}
		updateColNameColHeading();
	}
	void updateColNameColHeading()
	{
		if(m_bIsWksPages)
			SetColHeading(m_nNameCol, STR_HEADING_COL);
		else if(m_bIsMatrixPage)
			SetColHeading(m_nNameCol, STR_HEADING_MAT);
		else
			SetColHeading(m_nNameCol, STR_HEADING_DATASET);
	}
	//--------- CPY 3/28/05 SHOW_BOOK_SHEET_NAME_WITH_MULTIPLE_SHEETS_SELECTED
//	void updateShowWksNames()
//	{
//		string str;
//		for(int ii = 0; ii < m_vsPageNames.GetSize(); ii++)
//		{
//			if(ii > 0)
//				str += " ";
//			str += m_vsPageNames[ii];
//		}
//		m_staticCntrlPageNames.Text = str;
//	}
	string makeBookSheetName(const string& strBook, const string& strSheet, const string& strLastBook)
	{
		if(strLastBook.CompareNoCase(strBook) == 0)
			return strSheet;
		
		return make_book_sheet_name(strBook, strSheet);
	}
	void updateShowWksNames()
	{
		string str;
		string	strLastBookName;
		for(int ii = 0; ii < m_vsPageNames.GetSize(); ii++)
		{
			if(ii > 0)
				str += " ";
			str += makeBookSheetName(m_vsPageNames[ii], m_vsLayerNames[ii], strLastBookName);
			strLastBookName = m_vsPageNames[ii];
		}
		m_staticCntrlPageNames.Text = str;
	}
	//--------- end SHOW_BOOK_SHEET_NAME_WITH_MULTIPLE_SHEETS_SELECTED
	bool	isKeepColOrder() { return false;} // should be reading from m_dwAuxTypeInfo
	string getColDesignationName(int nColDesignation)
	{
		string str;
		char szTemp[50];
		if(get_plot_designation_str(nColDesignation, szTemp, 50))
			str = szTemp;
		//----- CPY 7/17/07 QA70-9867 POLAR_XY_SWITCHED
		if((m_dwAuxTypeInfo & MASK_PCD_LAYER_BITS) == PCD_LAYER_POLAR || (m_dwLayerBitsFromPlotTypeList & MASK_PCD_LAYER_BITS) == PCD_LAYER_POLAR)
		{
			/// ML 12/3/2007 QA70-10661 P2 SWAPPED_POLAR_PLOT_SOME_PS_LC_WORK
			//if(str.CompareNoCase("X")==0)
			//	str = "R";
			//else if(str.CompareNoCase("Y")==0)
			//	str = "Theta";
			BOOL			bPolarSwapped = PCD_POLAR_SWAPPED & m_dwAuxTypeInfo;
			string			strR = "R", strTheta = "Theta";
			if(str.CompareNoCase("X")==0)
				str = bPolarSwapped ? strR : strTheta;
			else if(str.CompareNoCase("Y")==0)
				str = bPolarSwapped ? strTheta : strR;
			/// end SWAPPED_POLAR_PLOT_SOME_PS_LC_WORK
		}
		//-----
		return str;
	}
	int colTypeToColDesignation(int nType) // OKDATAOBJ_DESIGNATION_Y --> COLDESIG_Y
	{
		int nColDesignation = cvt_col_type_to_designation(nType);
		if(isColDesignationInList(nColDesignation))
			return nColDesignation;
		
		return COLDESIG_NONE;
	}
	bool isColDesignationInList(int nColDesignation)
	{
		for(int ii = 0; ii < m_vnColDesignations.GetSize(); ii++)
		{
			if(m_vnColDesignations[ii] == nColDesignation)
				return true;
		}
		return false;
	}

private:
	ColumnInfo		m_ColInfo;			///Jasmine 07/16/08 QA80-11817 COLUMN_INFO_CLASS
	int				m_nInfoCols;
	vector<string> 	m_vsInfoCols;		///Kyle 07/18/08 CHANGE_INFO_COLUMN_SHOW_STYLE
	vector<bool> 	m_vbInfoColsShow;	///Kyle 07/18/08 CHANGE_INFO_COLUMN_SHOW_STYLE
	vector<int> 	m_vnUnavailableInfoCols;
	vector<uint> 	m_vnSelRows;		///Jasmine 10/15/08 QA80-12369 INDEPENDENTLY_REMEMBER_EACH_MODE_SECLECTION
	int				m_nRadioColBegin;
	int				m_nRadioColEnd;
	int				m_nNameCol;
	int				m_nLabelCol;
	int				m_nIndexCol; //CPY 8/6/03 ADD_COL_POSITION_IN_WKS
	int				m_n1stDataValCol;
	///Jasmine 07/16/08 QA80-11817 MORE_COLUMN_INFO_AND_CHECK_MENU
	int				m_nCommentsCol;
	int				m_nUnitsCol;
	int				m_nParaetersCol;
	int				m_nUserParaCol;
	int				m_nSamplingCol;
	///End MORE_COLUMN_INFO_AND_CHECK_MENU
	int				m_nMainCol;				///Jasmine 11/21/08 v8.0978b QA80-11938 ADD_LABEL_OR_ERR_INTO_EXSITING_PLOT
	DWORD 			m_dwAuxTypeInfo;
	DWORD			m_dwAuxPlotInfo;
	DWORD			m_dwLayerBitsFromPlotTypeList; //CPY 8/1/2007 QA70-9867 POLAR_XY_SWITCHED_FOR_XYZ_CONTOUR
	string			m_strColPattern;// "XYY" type of pattern
	int				m_nYs;// from m_strColPattern, as a cache value, must calll countYs everytime m_strColPattern is changed
	int				m_nModifiers; // number of needed modifiers
	int				m_nPlotType;
	int				m_nMakePlotExVal;
	vector<uint> 	m_vnColDesignations;
	vector<string>	m_vsLayerNames; // save a local copy
	vector<string>	m_vsPageNames; // wks pages, 
	vector<string>	m_vsColNames;
	vector<string>	m_vsColLongNames;
	vector<string> 	m_vsColWithDesig;	///Jasmine 10/13/08 QA80-11938 SHOW_DESIGNATION_IN_SHORT_NAME_COLUMN
	double			m_RowNumberXFrom;
	double			m_RowNumberXStep;
	bool			m_bIsWksPages;
	bool			m_bIsMatrixPage;
	bool			m_bIsFunctionPlots;
	bool			m_bIsVirtualMatrix;	///Sophy 8/3/2010 ORG-681-P2 PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG
	bool			m_bEditMode;
	int				m_nCommonColsModeSave;//---- CPY 1/2/2007 QA70-9168-P2 POPUP_MENU_FOR_COMMON_COL_CHOICES
	/// ML 4/12/2007 QA70-6961 PS_PLOT_RANGE_REMEMBERED_ON_REPLACE
	int				m_nRangeRows[2];
	/// end PS_PLOT_RANGE_REMEMBERED_ON_REPLACE

public:
	/// main dialog controls that we need to make use for this control
	Button			m_chkXErrBars;
	Button			m_chkPosNegErrBars;
	Button			m_chkAddRowNumX;
	Button			m_chkShowAllCols;
	Button			m_chkApplyWks;		///Jasmine 08/06/09 QA81-13749 AUTO_APPLY_DESTINATIONS_IN_COL_LIST	
	
#ifdef CHANGE_DESIGNATION_MODE_BTN
	BitmapRadioButton	m_btnDesignation;	///Jasmine 09/01/08 QA80-11938 ADD_CHANGE_DESIGNATION_MODE_BTN
	bool				m_bDesignation;		///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
#endif//CHANGE_DESIGNATION_MODE_BTN
	
private:
	Control			m_staticCntrlPageNames;
	//////////////////////////////////////
	Dialog*			m_pOwner;
};


///Kyle 07/18/08 CHANGE_INFO_COLUMN_SHOW_STYLE
class ColListControlSubMenu : public Menu
{
public:
	ColListControlSubMenu(const vector<string> & vsColNames, const vector<bool> & vbShow, const vector<int> &vnHiddenInfoCols);	
	void OnSubMenuItem(UINT nPos)
	{
	}
	bool GetCommand(int& nChoice, int nSelCmd);
private:
	int m_nItems;
};
///End CHANGE_INFO_COLUMN_SHOW_STYLE

class ColListControlMenu : public Menu
{
public:
	///Kyle 07/18/08 CHANGE_INFO_COLUMN_SHOW_STYLE
	//ColListControlMenu(ColListControl* pCLcntrl, int nRow, int nCol);
#ifdef CHANGE_DESIGNATION_MODE_BTN	
	ColListControlMenu(ColListControl* pCLcntrl, int nRow, int nCol, bool bDesignation, const Menu & subMenu);	///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
#else
	ColListControlMenu(ColListControl* pCLcntrl, int nRow, int nCol, const Menu & subMenu);	
#endif//CHANGE_DESIGNATION_MODE_BTN
	///End CHANGE_INFO_COLUMN_SHOW_STYLE

	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice);
private:
	int				m_nChoice;
};

#endif //_COL_DESIGNATIONS_H

